/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.VerificationTypeInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackMapFrameInfo {
    private static final int SAME_MIN = 0;
    private static final int SAME_MAX = 63;
    private static final int SAME_LOCALS_1_STACK_ITEM_MIN = 64;
    private static final int SAME_LOCALS_1_STACK_ITEM_MAX = 127;
    private static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    private static final int CHOP_MIN = 248;
    private static final int CHOP_MAX = 250;
    private static final int SAME_FRAME_EXTENDED = 251;
    private static final int APPEND_MIN = 252;
    private static final int APPEND_MAX = 254;
    private static final int FULL_FRAME = 255;
    private int u1frameType;
    private int u2offsetDelta;
    private List<VerificationTypeInfo> stack = Collections.emptyList();
    private List<VerificationTypeInfo> locals = Collections.emptyList();

    public static StackMapFrameInfo create(DataInput din) throws IOException, ClassFileException {
        StackMapFrameInfo smfi = new StackMapFrameInfo();
        smfi.read(din);
        return smfi;
    }

    private StackMapFrameInfo() {
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u1frameType = din.readUnsignedByte();
        if (0 > this.u1frameType || this.u1frameType > 63) {
            if (64 <= this.u1frameType && this.u1frameType <= 127) {
                this.readStackItems(din, 1);
            } else if (this.u1frameType == 247) {
                this.u2offsetDelta = din.readUnsignedShort();
                this.readStackItems(din, 1);
            } else if (248 <= this.u1frameType && this.u1frameType <= 250) {
                this.u2offsetDelta = din.readUnsignedShort();
            } else if (this.u1frameType == 251) {
                this.u2offsetDelta = din.readUnsignedShort();
            } else if (252 <= this.u1frameType && this.u1frameType <= 254) {
                this.u2offsetDelta = din.readUnsignedShort();
                int u2numberOfLocals = 1 + this.u1frameType - 252;
                this.readLocals(din, u2numberOfLocals);
            } else if (this.u1frameType == 255) {
                this.u2offsetDelta = din.readUnsignedShort();
                int u2numberOfLocals = din.readUnsignedShort();
                this.readLocals(din, u2numberOfLocals);
                int u2numberOfStackItems = din.readUnsignedShort();
                this.readStackItems(din, u2numberOfStackItems);
            }
        }
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        for (VerificationTypeInfo vt : this.stack) {
            vt.markUtf8Refs(pool);
        }
        for (VerificationTypeInfo vt : this.locals) {
            vt.markUtf8Refs(pool);
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeByte(this.u1frameType);
        if (0 > this.u1frameType || this.u1frameType > 63) {
            if (64 <= this.u1frameType && this.u1frameType <= 127) {
                this.writeStackItems(dout);
            } else if (this.u1frameType == 247) {
                dout.writeShort(this.u2offsetDelta);
                this.writeStackItems(dout);
            } else if (248 <= this.u1frameType && this.u1frameType <= 250) {
                dout.writeShort(this.u2offsetDelta);
            } else if (this.u1frameType == 251) {
                dout.writeShort(this.u2offsetDelta);
            } else if (252 <= this.u1frameType && this.u1frameType <= 254) {
                dout.writeShort(this.u2offsetDelta);
                this.writeLocals(dout);
            } else if (this.u1frameType == 255) {
                dout.writeShort(this.u2offsetDelta);
                dout.writeShort(this.locals.size());
                this.writeLocals(dout);
                dout.writeShort(this.stack.size());
                this.writeStackItems(dout);
            }
        }
    }

    private void readLocals(DataInput din, int items) throws IOException, ClassFileException {
        this.locals = new ArrayList<VerificationTypeInfo>(items);
        for (int i = 0; i < items; ++i) {
            this.locals.add(VerificationTypeInfo.create(din));
        }
    }

    private void writeLocals(DataOutput dout) throws IOException, ClassFileException {
        for (VerificationTypeInfo vt : this.locals) {
            vt.write(dout);
        }
    }

    private void readStackItems(DataInput din, int items) throws IOException, ClassFileException {
        this.stack = new ArrayList<VerificationTypeInfo>(items);
        for (int i = 0; i < items; ++i) {
            this.stack.add(VerificationTypeInfo.create(din));
        }
    }

    private void writeStackItems(DataOutput dout) throws IOException, ClassFileException {
        for (VerificationTypeInfo vt : this.stack) {
            vt.write(dout);
        }
    }
}

