/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NameAndTypeCpInfo
extends CpInfo
implements Cloneable {
    private int u2nameIndex;
    private int u2descriptorIndex;

    protected NameAndTypeCpInfo() {
        super(12);
    }

    public Object clone() {
        NameAndTypeCpInfo cloneInfo = new NameAndTypeCpInfo();
        cloneInfo.u2nameIndex = this.u2nameIndex;
        cloneInfo.u2descriptorIndex = this.u2descriptorIndex;
        cloneInfo.resetRefCount();
        return cloneInfo;
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int index) {
        this.u2nameIndex = index;
    }

    protected int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    protected void setDescriptorIndex(int index) {
        this.u2descriptorIndex = index;
    }

    @Override
    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2descriptorIndex);
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2nameIndex = din.readUnsignedShort();
        this.u2descriptorIndex = din.readUnsignedShort();
    }

    @Override
    protected void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2descriptorIndex);
    }
}

