/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassConstants;
import COM.rl.obf.classfile.ClassCpInfo;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.DoubleCpInfo;
import COM.rl.obf.classfile.FieldrefCpInfo;
import COM.rl.obf.classfile.FloatCpInfo;
import COM.rl.obf.classfile.IntegerCpInfo;
import COM.rl.obf.classfile.InterfaceMethodrefCpInfo;
import COM.rl.obf.classfile.InvokeDynamicCpInfo;
import COM.rl.obf.classfile.LongCpInfo;
import COM.rl.obf.classfile.MethodHandleCpInfo;
import COM.rl.obf.classfile.MethodTypeCpInfo;
import COM.rl.obf.classfile.MethodrefCpInfo;
import COM.rl.obf.classfile.NameAndTypeCpInfo;
import COM.rl.obf.classfile.StringCpInfo;
import COM.rl.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class CpInfo
implements ClassConstants {
    private int u1tag;
    protected int refCount = 0;

    public static CpInfo create(DataInput din) throws IOException, ClassFileException {
        if (din == null) {
            throw new IOException("No input stream was provided.");
        }
        CpInfo ci = null;
        switch (din.readUnsignedByte()) {
            case 1: {
                ci = new Utf8CpInfo();
                break;
            }
            case 3: {
                ci = new IntegerCpInfo();
                break;
            }
            case 4: {
                ci = new FloatCpInfo();
                break;
            }
            case 5: {
                ci = new LongCpInfo();
                break;
            }
            case 6: {
                ci = new DoubleCpInfo();
                break;
            }
            case 7: {
                ci = new ClassCpInfo();
                break;
            }
            case 8: {
                ci = new StringCpInfo();
                break;
            }
            case 9: {
                ci = new FieldrefCpInfo();
                break;
            }
            case 10: {
                ci = new MethodrefCpInfo();
                break;
            }
            case 11: {
                ci = new InterfaceMethodrefCpInfo();
                break;
            }
            case 12: {
                ci = new NameAndTypeCpInfo();
                break;
            }
            case 15: {
                ci = new MethodHandleCpInfo();
                break;
            }
            case 16: {
                ci = new MethodTypeCpInfo();
                break;
            }
            case 18: {
                ci = new InvokeDynamicCpInfo();
                break;
            }
            default: {
                throw new ClassFileException("Unknown tag type in constant pool.");
            }
        }
        ci.readInfo(din);
        return ci;
    }

    protected CpInfo(int tag) {
        this.u1tag = tag;
    }

    protected abstract void readInfo(DataInput var1) throws IOException, ClassFileException;

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
    }

    protected void markNTRefs(ConstantPool pool) throws ClassFileException {
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeByte(this.u1tag);
        this.writeInfo(dout);
    }

    protected abstract void writeInfo(DataOutput var1) throws IOException, ClassFileException;

    public int getRefCount() {
        return this.refCount;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() throws ClassFileException {
        if (this.refCount == 0) {
            throw new ClassFileException("Illegal to decrement ref count that is already zero.");
        }
        --this.refCount;
    }

    public void resetRefCount() {
        this.refCount = 0;
    }
}

