/*
 * Decompiled with CFR 0.152.
 */
package COM.rl;

import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.NameMapper;
import org.objectweb.asm.signature.SignatureException;
import org.objectweb.asm.signature.SignatureVisitor;

public class MapSignatureAdapter
extends SignatureVisitor {
    private SignatureVisitor sv;
    private String currentClassName;
    private NameMapper nm;

    public MapSignatureAdapter(SignatureVisitor sv, NameMapper nm) {
        super(0);
        this.sv = sv;
        this.nm = nm;
    }

    @Override
    public void visitFormalTypeParameter(String name) throws SignatureException {
        this.sv.visitFormalTypeParameter(name);
    }

    @Override
    public SignatureVisitor visitClassBound() throws SignatureException {
        this.sv.visitClassBound();
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() throws SignatureException {
        this.sv.visitInterfaceBound();
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() throws SignatureException {
        this.sv.visitSuperclass();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() throws SignatureException {
        this.sv.visitInterface();
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() throws SignatureException {
        this.sv.visitParameterType();
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() throws SignatureException {
        this.sv.visitReturnType();
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() throws SignatureException {
        this.sv.visitExceptionType();
        return this;
    }

    @Override
    public void visitBaseType(char descriptor) throws SignatureException {
        this.sv.visitBaseType(descriptor);
    }

    @Override
    public void visitTypeVariable(String name) throws SignatureException {
        this.sv.visitTypeVariable(name);
    }

    @Override
    public SignatureVisitor visitArrayType() throws SignatureException {
        this.sv.visitArrayType();
        return this;
    }

    @Override
    public void visitClassType(String name) throws SignatureException {
        this.currentClassName = name;
        String newName = null;
        try {
            newName = this.nm.mapClass(name);
        }
        catch (ClassFileException e) {
            throw new SignatureException(e);
        }
        this.sv.visitClassType(newName);
    }

    @Override
    public void visitInnerClassType(String name) throws SignatureException {
        this.currentClassName = this.currentClassName + "." + name;
        String newName = null;
        try {
            newName = this.nm.mapClass(this.currentClassName);
        }
        catch (ClassFileException e) {
            throw new SignatureException(e);
        }
        this.sv.visitInnerClassType(newName);
    }

    @Override
    public void visitTypeArgument() throws SignatureException {
        this.sv.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) throws SignatureException {
        this.sv.visitTypeArgument(wildcard);
        return this;
    }

    @Override
    public void visitEnd() throws SignatureException {
        this.sv.visitEnd();
    }
}

