package portalgun.api;

import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.entity.EntityEvent;

@Cancelable
public class SendEntityToTheMoonEvent extends EntityEvent 
{
	/**
	 * Event triggers when an entity is sent to the moon through a portalgun portal.
	 * Fields:
	 * entity = entity "sent" to the moon
	 * x, y, z, = coordinates of portal sending the entity to the moon.
	 * 
	 * To override, do setCanceled(true) and default behaviour will not occur.
	 * You are then free to do whatever you want with the entity. (Send to a moon dimension perhaps)
	 */

	public final int x;
	public final int y;
	public final int z;

	public SendEntityToTheMoonEvent(Entity entity, int i, int j, int k){
		super(entity);
		x = i;
		y = j;
		z = k;
	}

	/**
	 * Spawns a one way (if there is no other pair in the same dimension) FLOOR portal in the dimension/world specified. Coordinates should be the block above the block you want the portal to form on.
	 * Be sure to have sufficient space for a 2 block portal to form, or a portal will not spawn!
	 * @param world
	 * @param i
	 * @param j
	 * @param k
	 * @param portalPair - Cannot be null! Normally the tile entity that triggered this event is passed on.
	 */

	public void spawnPortalAt(World world, int i, int j, int k, TileEntity portalPair){
		try {
			Class.forName("portalgun.common.PortalGun").getMethod("spawnPortalAt", World.class, Integer.class, Integer.class, Integer.class, TileEntity.class).invoke(null, world, i, j, k, portalPair);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
