package mods.PamHarvestCraft.trees.pomegranate;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.pomegranate.PamHCPomegranate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPomegranate", name = "Pam's HarvestCraft Pomegranate", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPomegranate
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.pomegranate.ClientProxyPamHCPomegranate", serverSide = "mods.PamHarvestCraft.trees.pomegranate.CommonProxyPamHCPomegranate")
	public static CommonProxyPamHCPomegranate proxy;
	
	public static int pomegranateblockID = 3986;
	public static int pomegranatesaplingID = 3987;
	public static int pomegranatestorageID = 3988;
	
	public static int pomegranateID = 15715;

	public static int pomegranatecropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamPomegranateBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			pomegranateblockID = cfg.get(cfg.CATEGORY_BLOCK, "pomegranateblockID", 3986).getInt();
			pomegranatesaplingID = cfg.get(cfg.CATEGORY_BLOCK, "pomegranatesaplingID", 3987).getInt();
			pomegranatestorageID = cfg.get(cfg.CATEGORY_BLOCK, "pomegranatestorageID", 3988).getInt();
			pomegranateID = cfg.get(cfg.CATEGORY_ITEM, "pomegranateID", 15715).getInt();
			pomegranatecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"pomegranatecropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPomegranate has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamPomegranate;
    public static Block pampomegranateSapling;
    public static Block pampomegranateStorage;
    
    public static Item pomegranateItem;

    
    public static ItemStack pomegranate_0;
    public static ItemStack pomegranate_1;
    public static ItemStack pomegranate_2;
    
    public static ItemStack pomegranateSapling;
    public static ItemStack pomegranateStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamPomegranate = new BlockPamPomegranate(pomegranateblockID, "pomegranate");
		pampomegranateSapling = new BlockPamPomegranateSapling(pomegranatesaplingID).setUnlocalizedName("PamHarvestCraft:pomegranateSapling");
		pampomegranateStorage = new BlockPamStorage(pomegranatestorageID, 0).setUnlocalizedName("PamHarvestCraft:pomegranateStorage");
		
		pomegranateItem = new ItemPamFood(pomegranateID, pomegranatecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:pomegranateItem");

		MinecraftForge.addGrassPlant(pampomegranateSapling, 0, 25);
		
		ModLoader.registerBlock(pamPomegranate, ItemPamPomegranate.class);
		ModLoader.registerBlock(pampomegranateSapling);
		ModLoader.registerBlock(pampomegranateStorage);
		
		
		
		//Block Names
				pomegranate_0 = new ItemStack(pamPomegranate, 1, 0);
				pomegranate_1 = new ItemStack(pamPomegranate, 1, 1);
				pomegranate_2 = new ItemStack(pamPomegranate, 1, 2);
		        
		        pomegranateSapling = new ItemStack(pampomegranateSapling, 1, 0);
		        pomegranateStorage = new ItemStack(pampomegranateStorage, 1, 0);

		        LanguageRegistry.addName(pomegranate_0, "Very Unripe Pomegranate");
		        LanguageRegistry.addName(pomegranate_1, "Unripe Pomegranate");
		        LanguageRegistry.addName(pomegranate_2, "Ripe Pomegranate");
		        
		        LanguageRegistry.addName(pomegranateSapling, "Pomegranate Sapling");
		        LanguageRegistry.addName(pomegranateStorage, "Pomegranate Crate");
		        
		        LanguageRegistry.addName(pomegranateItem, "Pomegranate");

		        OreDictionary.registerOre("cropPomegranate", PamHCPomegranate.pomegranateItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPomegranate.pomegranateItem, 2), "cropPomegranate", "cropPomegranate"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCPomegranate.pampomegranateSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCPomegranate.pomegranateItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPomegranate.pampomegranateStorage, "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate", "cropPomegranate"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPomegranate.pomegranateItem, 9), pampomegranateStorage));
		
		GameRegistry.registerWorldGenerator(new PamPomegranateGenerator());
	 
	 }


}