package mods.PamHarvestCraft.trees.plum;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPlum", name = "Pam's HarvestCraft Plum", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPlum
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.plum.ClientProxyPamHCPlum", serverSide = "mods.PamHarvestCraft.trees.plum.CommonProxyPamHCPlum")
	public static CommonProxyPamHCPlum proxy;
	
	public static int plumblockID = 3950;
	public static int plumsaplingID = 3951;
	public static int plumstorageID = 3952;
	public static int plumID = 15702;
	
	public static int plumcropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamPlumBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			plumblockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "plumblockID", 3950).getInt();
			plumsaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "plumsaplingID", 3951).getInt();
			plumstorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "plumstorageID", 3952).getInt();
			plumID = cfg.get(cfg.CATEGORY_ITEM, "plumID", 15702).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			plumcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"plumcropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPlum has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamPlum;
    public static Block pamplumSapling;
    public static Block pamplumStorage;
    
    public static Item plumItem;
    
    public static ItemStack plum_0;
    public static ItemStack plum_1;
    public static ItemStack plum_2;
    
    public static ItemStack plumSapling;
    public static ItemStack plumStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamPlum = new BlockPamPlum(plumblockID, "plum");
		pamplumSapling = new BlockPamPlumSapling(plumsaplingID).setUnlocalizedName("PamHarvestCraft:plumSapling");
		pamplumStorage = new BlockPamStorage(plumstorageID, 0).setUnlocalizedName("PamHarvestCraft:plumStorage");
		
		plumItem = new ItemPamFood(plumID, plumcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:plumItem");
		
		MinecraftForge.addGrassPlant(pamplumSapling, 0, 25);
		
		ModLoader.registerBlock(pamPlum, ItemPamPlum.class);
		ModLoader.registerBlock(pamplumSapling);
		ModLoader.registerBlock(pamplumStorage);
		
		//Block Names
		plum_0 = new ItemStack(pamPlum, 1, 0);
		plum_1 = new ItemStack(pamPlum, 1, 1);
		plum_2 = new ItemStack(pamPlum, 1, 2);
        
        plumSapling = new ItemStack(pamplumSapling, 1, 0);
        plumStorage = new ItemStack(pamplumStorage, 1, 0);
        
        LanguageRegistry.addName(plum_0, "Very Unripe Plum");
        LanguageRegistry.addName(plum_1, "Unripe Plum");
        LanguageRegistry.addName(plum_2, "Ripe Plum");
        
        LanguageRegistry.addName(plumSapling, "Plum Sapling");
        LanguageRegistry.addName(plumStorage, "Plum Crate");
        
        LanguageRegistry.addName(plumItem, "Plum");
        
        OreDictionary.registerOre("cropPlum", PamHCPlum.plumItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCPlum.pamplumSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCPlum.plumItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPlum.pamplumStorage, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem, PamHCPlum.plumItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPlum.plumItem, 9), pamplumStorage));
		
		GameRegistry.registerWorldGenerator(new PamPlumGenerator());
	 
	 }

}