package mods.PamHarvestCraft.trees.pear;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.pear.PamHCPear;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPear", name = "Pam's HarvestCraft Pear", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPear
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.pear.ClientProxyPamHCPear", serverSide = "mods.PamHarvestCraft.trees.pear.CommonProxyPamHCPear")
	public static CommonProxyPamHCPear proxy;
	
	public static int pearblockID = 3947;
	public static int pearsaplingID = 3948;
	public static int pearstorageID = 3949;
	public static int pearID = 15701;

	public static int pearcropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamPearBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			pearblockID = cfg.get(cfg.CATEGORY_BLOCK, "pearblockID", 3947).getInt();
			pearsaplingID = cfg.get(cfg.CATEGORY_BLOCK, "pearsaplingID", 3948).getInt();
			pearstorageID = cfg.get(cfg.CATEGORY_BLOCK, "pearstorageID", 3949).getInt();
			pearID = cfg.get(cfg.CATEGORY_ITEM, "pearID", 15701).getInt();
			pearcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"pearcropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPear has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamPear;
    public static Block pampearSapling;
    public static Block pampearStorage;
    
    public static Item pearItem;

    
    public static ItemStack pear_0;
    public static ItemStack pear_1;
    public static ItemStack pear_2;
    
    public static ItemStack pearSapling;
    public static ItemStack pearStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamPear = new BlockPamPear(pearblockID, "pear");
		pampearSapling = new BlockPamPearSapling(pearsaplingID).setUnlocalizedName("PamHarvestCraft:pearSapling");
		pampearStorage = new BlockPamStorage(pearstorageID, 0).setUnlocalizedName("PamHarvestCraft:pearStorage");
		
		pearItem = new ItemPamFood(pearID, pearcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:pearItem");

		MinecraftForge.addGrassPlant(pampearSapling, 0, 25);
		
		ModLoader.registerBlock(pamPear, ItemPamPear.class);
		ModLoader.registerBlock(pampearSapling);
		ModLoader.registerBlock(pampearStorage);
		
		
		
		//Block Names
				pear_0 = new ItemStack(pamPear, 1, 0);
				pear_1 = new ItemStack(pamPear, 1, 1);
				pear_2 = new ItemStack(pamPear, 1, 2);
		        
		        pearSapling = new ItemStack(pampearSapling, 1, 0);
		        pearStorage = new ItemStack(pampearStorage, 1, 0);

		        LanguageRegistry.addName(pear_0, "Very Unripe Pear");
		        LanguageRegistry.addName(pear_1, "Unripe Pear");
		        LanguageRegistry.addName(pear_2, "Ripe Pear");
		        
		        LanguageRegistry.addName(pearSapling, "Pear Sapling");
		        LanguageRegistry.addName(pearStorage, "Pear Crate");
		        
		        LanguageRegistry.addName(pearItem, "Pear");

		        OreDictionary.registerOre("cropPear", PamHCPear.pearItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPear.pearItem, 2), "cropPear", "cropPear"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCPear.pampearSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCPear.pearItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPear.pampearStorage, "cropPear", "cropPear", "cropPear", "cropPear", "cropPear", "cropPear", "cropPear", "cropPear", "cropPear"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPear.pearItem, 9), pampearStorage));
		
		GameRegistry.registerWorldGenerator(new PamPearGenerator());
	 
	 }


}