package mods.PamHarvestCraft.trees.pear;

import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BlockPamPearSapling extends BlockFlower
{
	
    protected BlockPamPearSapling(int i)
    {
        super(i);
        float f = 0.4F;
        setBlockBounds(0.5F - f, 0.0F, 0.5F - f, 0.5F + f, f * 2.0F, 0.5F + f);
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        this.setStepSound(Block.soundGrassFootstep);
    }

    public int damageDropped(int i)
    {
        return i;
    }

    public void updateTick(World world, int i, int j, int k, Random random)
    {
        super.updateTick(world, i, j, k, random);

        if (world.getBlockLightValue(i, j + 1, k) >= 9 && random.nextInt(30) == 0)
        {
            int l = world.getBlockMetadata(i, j, k);

            if (random.nextInt(3) == 0)
            {
                generateTree(world, i, j, k, random, l);
            }
        }
    }

    public void generateTree(World world, int i, int j, int k, Random random, int l)
    {
        world.setBlock(i, j, k, 0);

        WorldGenPamPear worldgenpampear = new WorldGenPamPear(l);

        if (!((WorldGenerator)worldgenpampear).generate(world, random, i, j, k))
        {
            world.setBlock(i, j, k, blockID);
        }
    }
    
    public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        par3List.add(new ItemStack(par1, 1, 0));



    }
}

