package mods.PamHarvestCraft.trees.peach;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.peach.PamHCPeach;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPeach", name = "Pam's HarvestCraft Peach", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPeach
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.peach.ClientProxyPamHCPeach", serverSide = "mods.PamHarvestCraft.trees.peach.CommonProxyPamHCPeach")
	public static CommonProxyPamHCPeach proxy;
	
	public static int peachblockID = 3974;
	public static int peachsaplingID = 3975;
	public static int peachstorageID = 3976;
	
	public static int peachID = 15711;

	public static int peachcropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamPeachBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			peachblockID = cfg.get(cfg.CATEGORY_BLOCK, "peachblockID", 3974).getInt();
			peachsaplingID = cfg.get(cfg.CATEGORY_BLOCK, "peachsaplingID", 3975).getInt();
			peachstorageID = cfg.get(cfg.CATEGORY_BLOCK, "peachstorageID", 3976).getInt();
			peachID = cfg.get(cfg.CATEGORY_ITEM, "peachID", 15711).getInt();
			peachcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"peachcropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPeach has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamPeach;
    public static Block pampeachSapling;
    public static Block pampeachStorage;
    
    public static Item peachItem;

    
    public static ItemStack peach_0;
    public static ItemStack peach_1;
    public static ItemStack peach_2;
    
    public static ItemStack peachSapling;
    public static ItemStack peachStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamPeach = new BlockPamPeach(peachblockID, "peach");
		pampeachSapling = new BlockPamPeachSapling(peachsaplingID).setUnlocalizedName("PamHarvestCraft:peachSapling");
		pampeachStorage = new BlockPamStorage(peachstorageID, 0).setUnlocalizedName("PamHarvestCraft:peachStorage");
		
		peachItem = new ItemPamFood(peachID, peachcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:peachItem");

		MinecraftForge.addGrassPlant(pampeachSapling, 0, 25);
		
		ModLoader.registerBlock(pamPeach, ItemPamPeach.class);
		ModLoader.registerBlock(pampeachSapling);
		ModLoader.registerBlock(pampeachStorage);
		
		
		
		//Block Names
				peach_0 = new ItemStack(pamPeach, 1, 0);
				peach_1 = new ItemStack(pamPeach, 1, 1);
				peach_2 = new ItemStack(pamPeach, 1, 2);
		        
		        peachSapling = new ItemStack(pampeachSapling, 1, 0);
		        peachStorage = new ItemStack(pampeachStorage, 1, 0);

		        LanguageRegistry.addName(peach_0, "Very Unripe Peach");
		        LanguageRegistry.addName(peach_1, "Unripe Peach");
		        LanguageRegistry.addName(peach_2, "Ripe Peach");
		        
		        LanguageRegistry.addName(peachSapling, "Peach Sapling");
		        LanguageRegistry.addName(peachStorage, "Peach Crate");
		        
		        LanguageRegistry.addName(peachItem, "Peach");

		        OreDictionary.registerOre("cropPeach", PamHCPeach.peachItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeach.peachItem, 2), "cropPeach", "cropPeach"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCPeach.pampeachSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCPeach.peachItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeach.pampeachStorage, "cropPeach", "cropPeach", "cropPeach", "cropPeach", "cropPeach", "cropPeach", "cropPeach", "cropPeach", "cropPeach"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeach.peachItem, 9), pampeachStorage));
		
		GameRegistry.registerWorldGenerator(new PamPeachGenerator());
	 
	 }


}