package mods.PamHarvestCraft.trees.papaya;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPapaya", name = "Pam's HarvestCraft Papaya", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPapaya
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.papaya.ClientProxyPamHCPapaya", serverSide = "mods.PamHarvestCraft.trees.papaya.CommonProxyPamHCPapaya")
	public static CommonProxyPamHCPapaya proxy;
	
	public static int papayablockID = 3965;
	public static int papayasaplingID = 3966;
	public static int papayastorageID = 3967;
	
	public static int papayaID = 15708;
	
	public static int papayacropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamPapayaBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			papayablockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "papayablockID", 3965).getInt();
			papayasaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "papayasaplingID", 3966).getInt();
			papayastorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "papayastorageID", 3967).getInt();
			papayaID = cfg.get(cfg.CATEGORY_ITEM, "papayaID", 15708).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			papayacropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"papayacropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPapaya has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamPapaya;
    public static Block pampapayaSapling;
    public static Block pampapayaStorage;
    
    public static Item papayaItem;
    
    public static ItemStack papaya_0;
    public static ItemStack papaya_1;
    public static ItemStack papaya_2;
    
    public static ItemStack papayaSapling;
    public static ItemStack papayaStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamPapaya = new BlockPamPapaya(papayablockID, "papaya");
		pampapayaSapling = new BlockPamPapayaSapling(papayasaplingID).setUnlocalizedName("PamHarvestCraft:papayaSapling");
		pampapayaStorage = new BlockPamStorage(papayastorageID, 0).setUnlocalizedName("PamHarvestCraft:papayaStorage");
		
		papayaItem = new ItemPamFood(papayaID, papayacropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:papayaItem");
		
		MinecraftForge.addGrassPlant(pampapayaSapling, 0, 25);
		
		ModLoader.registerBlock(pamPapaya, ItemPamPapaya.class);
		ModLoader.registerBlock(pampapayaSapling);
		ModLoader.registerBlock(pampapayaStorage);
		
		//Block Names
		papaya_0 = new ItemStack(pamPapaya, 1, 0);
		papaya_1 = new ItemStack(pamPapaya, 1, 1);
		papaya_2 = new ItemStack(pamPapaya, 1, 2);
        
        papayaSapling = new ItemStack(pampapayaSapling, 1, 0);
        papayaStorage = new ItemStack(pampapayaStorage, 1, 0);
        
        LanguageRegistry.addName(papaya_0, "Very Unripe Papaya");
        LanguageRegistry.addName(papaya_1, "Unripe Papaya");
        LanguageRegistry.addName(papaya_2, "Ripe Papaya");
        
        LanguageRegistry.addName(papayaSapling, "Papaya Sapling");
        LanguageRegistry.addName(papayaStorage, "Papaya Crate");
        
        LanguageRegistry.addName(papayaItem, "Papaya");
        
        OreDictionary.registerOre("cropPapaya", PamHCPapaya.papayaItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCPapaya.pampapayaSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCPapaya.papayaItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPapaya.pampapayaStorage, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem, PamHCPapaya.papayaItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPapaya.papayaItem, 9), pampapayaStorage));
		
		GameRegistry.registerWorldGenerator(new PamPapayaGenerator());
	 
	 }

}