package mods.PamHarvestCraft.trees.orange;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.orange.PamHCOrange;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCOrange", name = "Pam's HarvestCraft Orange", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCOrange
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.orange.ClientProxyPamHCOrange", serverSide = "mods.PamHarvestCraft.trees.orange.CommonProxyPamHCOrange")
	public static CommonProxyPamHCOrange proxy;
	
	public static int orangeblockID = 3971;
	public static int orangesaplingID = 3972;
	public static int orangestorageID = 3973;
	
	public static int orangeID = 15710;

	public static int orangecropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamOrangeBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			orangeblockID = cfg.get(cfg.CATEGORY_BLOCK, "orangeblockID", 3971).getInt();
			orangesaplingID = cfg.get(cfg.CATEGORY_BLOCK, "orangesaplingID", 3972).getInt();
			orangestorageID = cfg.get(cfg.CATEGORY_BLOCK, "orangestorageID", 3973).getInt();
			orangeID = cfg.get(cfg.CATEGORY_ITEM, "orangeID", 15710).getInt();
			orangecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"orangecropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCOrange has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamOrange;
    public static Block pamorangeSapling;
    public static Block pamorangeStorage;
    
    public static Item orangeItem;

    
    public static ItemStack orange_0;
    public static ItemStack orange_1;
    public static ItemStack orange_2;
    
    public static ItemStack orangeSapling;
    public static ItemStack orangeStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamOrange = new BlockPamOrange(orangeblockID, "orange");
		pamorangeSapling = new BlockPamOrangeSapling(orangesaplingID).setUnlocalizedName("PamHarvestCraft:orangeSapling");
		pamorangeStorage = new BlockPamStorage(orangestorageID, 0).setUnlocalizedName("PamHarvestCraft:orangeStorage");
		
		orangeItem = new ItemPamFood(orangeID, orangecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:orangeItem");

		MinecraftForge.addGrassPlant(pamorangeSapling, 0, 25);
		
		ModLoader.registerBlock(pamOrange, ItemPamOrange.class);
		ModLoader.registerBlock(pamorangeSapling);
		ModLoader.registerBlock(pamorangeStorage);
		
		
		
		//Block Names
				orange_0 = new ItemStack(pamOrange, 1, 0);
				orange_1 = new ItemStack(pamOrange, 1, 1);
				orange_2 = new ItemStack(pamOrange, 1, 2);
		        
		        orangeSapling = new ItemStack(pamorangeSapling, 1, 0);
		        orangeStorage = new ItemStack(pamorangeStorage, 1, 0);

		        LanguageRegistry.addName(orange_0, "Very Unripe Orange");
		        LanguageRegistry.addName(orange_1, "Unripe Orange");
		        LanguageRegistry.addName(orange_2, "Ripe Orange");
		        
		        LanguageRegistry.addName(orangeSapling, "Orange Sapling");
		        LanguageRegistry.addName(orangeStorage, "Orange Crate");
		        
		        LanguageRegistry.addName(orangeItem, "Orange");

		        OreDictionary.registerOre("cropOrange", PamHCOrange.orangeItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOrange.orangeItem, 2), "cropOrange", "cropOrange"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCOrange.pamorangeSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCOrange.orangeItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOrange.pamorangeStorage, "cropOrange", "cropOrange", "cropOrange", "cropOrange", "cropOrange", "cropOrange", "cropOrange", "cropOrange", "cropOrange"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOrange.orangeItem, 9), pamorangeStorage));
		
		GameRegistry.registerWorldGenerator(new PamOrangeGenerator());
	 
	 }


}