package mods.PamHarvestCraft.trees.olive;

import java.util.Random;

import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraft.world.chunk.IChunkProvider;
import cpw.mods.fml.common.IWorldGenerator;

public class PamOliveGenerator implements IWorldGenerator {

	@Override
	public void generate(Random random, int chunkX, int chunkZ, World world,
			IChunkProvider chunkGenerator, IChunkProvider chunkProvider) 
	{
	      generateSurface(world, random, chunkX * 16, chunkZ * 16);
	}

	public void generateSurface(World world, Random rand, int chunkX, int chunkZ)
    {
    	BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(chunkX, chunkZ);
	
		for (int k = 0; k < PamHCOlive.treerarity; k++)
		{
			for (int treeType = 0; treeType < 1; treeType++)
			{
				int l = rand.nextInt(128);
				int i1 = chunkX + rand.nextInt(16);
				int j1 = chunkZ + rand.nextInt(16);
				if ((world.getBlockId(i1, l - 1, j1) == 2 || world.getBlockId(i1, l - 1, j1) == 3))
				{
					(new WorldGenPamOlive(treeType)).generate(world, rand, i1, l, j1);
				}
			}
		}
	}
  

}
