package mods.PamHarvestCraft.trees.olive;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.olive.PamHCOlive;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCOlive", name = "Pam's HarvestCraft Olive", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCOlive
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.olive.ClientProxyPamHCOlive", serverSide = "mods.PamHarvestCraft.trees.olive.CommonProxyPamHCOlive")
	public static CommonProxyPamHCOlive proxy;
	
	public static int oliveblockID = 3983;
	public static int olivesaplingID = 3984;
	public static int olivestorageID = 3985;
	
	public static int oliveID = 15714;

	public static int olivecropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamOliveBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			oliveblockID = cfg.get(cfg.CATEGORY_BLOCK, "oliveblockID", 3983).getInt();
			olivesaplingID = cfg.get(cfg.CATEGORY_BLOCK, "olivesaplingID", 3984).getInt();
			olivestorageID = cfg.get(cfg.CATEGORY_BLOCK, "olivestorageID", 3985).getInt();
			oliveID = cfg.get(cfg.CATEGORY_ITEM, "oliveID", 15714).getInt();
			olivecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"olivecropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCOlive has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamOlive;
    public static Block pamoliveSapling;
    public static Block pamoliveStorage;
    
    public static Item oliveItem;

    
    public static ItemStack olive_0;
    public static ItemStack olive_1;
    public static ItemStack olive_2;
    
    public static ItemStack oliveSapling;
    public static ItemStack oliveStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamOlive = new BlockPamOlive(oliveblockID, "olive");
		pamoliveSapling = new BlockPamOliveSapling(olivesaplingID).setUnlocalizedName("PamHarvestCraft:oliveSapling");
		pamoliveStorage = new BlockPamStorage(olivestorageID, 0).setUnlocalizedName("PamHarvestCraft:oliveStorage");
		
		oliveItem = new ItemPamFood(oliveID, olivecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:oliveItem");

		MinecraftForge.addGrassPlant(pamoliveSapling, 0, 25);
		
		ModLoader.registerBlock(pamOlive, ItemPamOlive.class);
		ModLoader.registerBlock(pamoliveSapling);
		ModLoader.registerBlock(pamoliveStorage);
		
		
		
		//Block Names
				olive_0 = new ItemStack(pamOlive, 1, 0);
				olive_1 = new ItemStack(pamOlive, 1, 1);
				olive_2 = new ItemStack(pamOlive, 1, 2);
		        
		        oliveSapling = new ItemStack(pamoliveSapling, 1, 0);
		        oliveStorage = new ItemStack(pamoliveStorage, 1, 0);

		        LanguageRegistry.addName(olive_0, "Very Unripe Olive");
		        LanguageRegistry.addName(olive_1, "Unripe Olive");
		        LanguageRegistry.addName(olive_2, "Ripe Olive");
		        
		        LanguageRegistry.addName(oliveSapling, "Olive Sapling");
		        LanguageRegistry.addName(oliveStorage, "Olive Crate");
		        
		        LanguageRegistry.addName(oliveItem, "Olive");

		        OreDictionary.registerOre("cropOlive", PamHCOlive.oliveItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOlive.oliveItem, 2), "cropOlive", "cropOlive"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCOlive.pamoliveSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCOlive.oliveItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOlive.pamoliveStorage, "cropOlive", "cropOlive", "cropOlive", "cropOlive", "cropOlive", "cropOlive", "cropOlive", "cropOlive", "cropOlive"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOlive.oliveItem, 9), pamoliveStorage));
		
		GameRegistry.registerWorldGenerator(new PamOliveGenerator());
	 
	 }


}