package mods.PamHarvestCraft.trees.nutmeg;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCNutmeg", name = "Pam's HarvestCraft Nutmeg", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCNutmeg
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.nutmeg.ClientProxyPamHCNutmeg", serverSide = "mods.PamHarvestCraft.trees.nutmeg.CommonProxyPamHCNutmeg")
	public static CommonProxyPamHCNutmeg proxy;
	
	public static int nutmegblockID = 3956;
	public static int nutmegsaplingID = 3957;
	public static int nutmegstorageID = 3958;
	public static int nutmegID = 15704;
	
	public static int nutmegcropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamNutmegBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			nutmegblockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "nutmegblockID", 3956).getInt();
			nutmegsaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "nutmegsaplingID", 3957).getInt();
			nutmegstorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "nutmegstorageID", 3958).getInt();
			nutmegID = cfg.get(cfg.CATEGORY_ITEM, "nutmegID", 15704).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			nutmegcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"nutmegcropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCNutmeg has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamNutmeg;
    public static Block pamnutmegSapling;
    public static Block pamnutmegStorage;
    
    public static Item nutmegItem;
    
    public static ItemStack nutmeg_0;
    public static ItemStack nutmeg_1;
    public static ItemStack nutmeg_2;
    
    public static ItemStack nutmegSapling;
    public static ItemStack nutmegStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamNutmeg = new BlockPamNutmeg(nutmegblockID, "nutmeg");
		pamnutmegSapling = new BlockPamNutmegSapling(nutmegsaplingID).setUnlocalizedName("PamHarvestCraft:nutmegSapling");
		pamnutmegStorage = new BlockPamStorage(nutmegstorageID, 0).setUnlocalizedName("PamHarvestCraft:nutmegStorage");
		
		nutmegItem = new ItemPamFood(nutmegID, nutmegcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:nutmegItem");
		
		MinecraftForge.addGrassPlant(pamnutmegSapling, 0, 25);
		
		ModLoader.registerBlock(pamNutmeg, ItemPamNutmeg.class);
		ModLoader.registerBlock(pamnutmegSapling);
		ModLoader.registerBlock(pamnutmegStorage);
		
		//Block Names
		nutmeg_0 = new ItemStack(pamNutmeg, 1, 0);
		nutmeg_1 = new ItemStack(pamNutmeg, 1, 1);
		nutmeg_2 = new ItemStack(pamNutmeg, 1, 2);
        
        nutmegSapling = new ItemStack(pamnutmegSapling, 1, 0);
        nutmegStorage = new ItemStack(pamnutmegStorage, 1, 0);
        
        LanguageRegistry.addName(nutmeg_0, "Very Unripe Nutmeg");
        LanguageRegistry.addName(nutmeg_1, "Unripe Nutmeg");
        LanguageRegistry.addName(nutmeg_2, "Ripe Nutmeg");
        
        LanguageRegistry.addName(nutmegSapling, "Nutmeg Sapling");
        LanguageRegistry.addName(nutmegStorage, "Nutmeg Crate");
        
        LanguageRegistry.addName(nutmegItem, "Nutmeg");
        
        OreDictionary.registerOre("cropNutmeg", PamHCNutmeg.nutmegItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCNutmeg.pamnutmegSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCNutmeg.nutmegItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCNutmeg.pamnutmegStorage, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem, PamHCNutmeg.nutmegItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCNutmeg.nutmegItem, 9), pamnutmegStorage));
		
		GameRegistry.registerWorldGenerator(new PamNutmegGenerator());
	 
	 }

}