package mods.PamHarvestCraft.trees.mango;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.mango.PamHCMango;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCMango", name = "Pam's HarvestCraft Mango", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCMango
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.mango.ClientProxyPamHCMango", serverSide = "mods.PamHarvestCraft.trees.mango.CommonProxyPamHCMango")
	public static CommonProxyPamHCMango proxy;
	
	public static int mangoblockID = 3980;
	public static int mangosaplingID = 3981;
	public static int mangostorageID = 3982;
	
	public static int mangoID = 15713;

	public static int mangocropfoodrestore = 1;
	public static int treerarity = 2;

    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamMangoBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			mangoblockID = cfg.get(cfg.CATEGORY_BLOCK, "mangoblockID", 3980).getInt();
			mangosaplingID = cfg.get(cfg.CATEGORY_BLOCK, "mangosaplingID", 3981).getInt();
			mangostorageID = cfg.get(cfg.CATEGORY_BLOCK, "mangostorageID", 3982).getInt();
			mangoID = cfg.get(cfg.CATEGORY_ITEM, "mangoID", 15713).getInt();
			mangocropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"mangocropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCMango has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamMango;
    public static Block pammangoSapling;
    public static Block pammangoStorage;
    
    public static Item mangoItem;

    
    public static ItemStack mango_0;
    public static ItemStack mango_1;
    public static ItemStack mango_2;
    
    public static ItemStack mangoSapling;
    public static ItemStack mangoStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamMango = new BlockPamMango(mangoblockID, "mango");
		pammangoSapling = new BlockPamMangoSapling(mangosaplingID).setUnlocalizedName("PamHarvestCraft:mangoSapling");
		pammangoStorage = new BlockPamStorage(mangostorageID, 0).setUnlocalizedName("PamHarvestCraft:mangoStorage");
		
		mangoItem = new ItemPamFood(mangoID, mangocropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:mangoItem");

		MinecraftForge.addGrassPlant(pammangoSapling, 0, 25);
		
		ModLoader.registerBlock(pamMango, ItemPamMango.class);
		ModLoader.registerBlock(pammangoSapling);
		ModLoader.registerBlock(pammangoStorage);
		
		
		
		//Block Names
				mango_0 = new ItemStack(pamMango, 1, 0);
				mango_1 = new ItemStack(pamMango, 1, 1);
				mango_2 = new ItemStack(pamMango, 1, 2);
		        
		        mangoSapling = new ItemStack(pammangoSapling, 1, 0);
		        mangoStorage = new ItemStack(pammangoStorage, 1, 0);

		        LanguageRegistry.addName(mango_0, "Very Unripe Mango");
		        LanguageRegistry.addName(mango_1, "Unripe Mango");
		        LanguageRegistry.addName(mango_2, "Ripe Mango");
		        
		        LanguageRegistry.addName(mangoSapling, "Mango Sapling");
		        LanguageRegistry.addName(mangoStorage, "Mango Crate");
		        
		        LanguageRegistry.addName(mangoItem, "Mango");

		        OreDictionary.registerOre("cropMango", PamHCMango.mangoItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMango.mangoItem, 2), "cropMango", "cropMango"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCMango.pammangoSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCMango.mangoItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCMango.pammangoStorage, "cropMango", "cropMango", "cropMango", "cropMango", "cropMango", "cropMango", "cropMango", "cropMango", "cropMango"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMango.mangoItem, 9), pammangoStorage));
		
		GameRegistry.registerWorldGenerator(new PamMangoGenerator());
	 
	 }


}