package mods.PamHarvestCraft.trees.lemon;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.lemon.PamHCLemon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCLemon", name = "Pam's HarvestCraft Lemon", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCLemon
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.lemon.ClientProxyPamHCLemon", serverSide = "mods.PamHarvestCraft.trees.lemon.CommonProxyPamHCLemon")
	public static CommonProxyPamHCLemon proxy;
	
	public static int lemonblockID = 4084;
	public static int lemonsaplingID = 4085;
	public static int lemonstorageID = 4086;
	
	public static int lemonID = 15526;

	public static int combustiblelemonID = 15534;
	
	public static int lemoncropfoodrestore = 1;
	public static int treerarity = 2;
	
	
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamLemonBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			lemonblockID = cfg.get(cfg.CATEGORY_BLOCK, "lemonblockID", 4084).getInt();
			lemonsaplingID = cfg.get(cfg.CATEGORY_BLOCK, "lemonsaplingID", 4085).getInt();
			lemonstorageID = cfg.get(cfg.CATEGORY_BLOCK, "lemonstorageID", 4086).getInt();
			lemonID = cfg.get(cfg.CATEGORY_ITEM, "lemonID", 15526).getInt();

			combustiblelemonID = cfg.get(cfg.CATEGORY_ITEM, "combustiblelemonID", 15534).getInt();
			lemoncropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"lemoncropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCLemon has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamLemon;
    public static Block pamlemonSapling;
    public static Block pamlemonStorage;
    
    public static Item lemonItem;

    public static Item combustiblelemonItem;
    
    public static ItemStack lemon_0;
    public static ItemStack lemon_1;
    public static ItemStack lemon_2;
    
    public static ItemStack lemonSapling;
    public static ItemStack lemonStorage;
    
    public static ItemStack combustiblelemon;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		EntityRegistry.registerModEntity(EntityCombustibleLemon.class, "Combustible Lemon", 550, this, 8, 1, true);
		
		pamLemon = new BlockPamLemon(lemonblockID, "lemon");
		pamlemonSapling = new BlockPamLemonSapling(lemonsaplingID).setUnlocalizedName("PamHarvestCraft:lemonSapling");
		pamlemonStorage = new BlockPamStorage(lemonstorageID, 0).setUnlocalizedName("PamHarvestCraft:lemonStorage");
		
		lemonItem = new ItemPamFood(lemonID, lemoncropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:lemonItem");

		combustiblelemonItem = new ItemPamCombustibleLemon(combustiblelemonID).setUnlocalizedName("PamHarvestCraft:combustiblelemonItem");
		
		MinecraftForge.addGrassPlant(pamlemonSapling, 0, 25);
		
		ModLoader.registerBlock(pamLemon, ItemPamLemon.class);
		ModLoader.registerBlock(pamlemonSapling);
		ModLoader.registerBlock(pamlemonStorage);
		
		
		
		//Block Names
				lemon_0 = new ItemStack(pamLemon, 1, 0);
				lemon_1 = new ItemStack(pamLemon, 1, 1);
				lemon_2 = new ItemStack(pamLemon, 1, 2);
		        
		        lemonSapling = new ItemStack(pamlemonSapling, 1, 0);
		        lemonStorage = new ItemStack(pamlemonStorage, 1, 0);
		        
		        combustiblelemon = new ItemStack(combustiblelemonItem, 1, 0);
		        
		        LanguageRegistry.addName(lemon_0, "Very Unripe Lemon");
		        LanguageRegistry.addName(lemon_1, "Unripe Lemon");
		        LanguageRegistry.addName(lemon_2, "Ripe Lemon");
		        
		        LanguageRegistry.addName(lemonSapling, "Lemon Sapling");
		        LanguageRegistry.addName(lemonStorage, "Lemon Crate");
		        
		        LanguageRegistry.addName(lemonItem, "Lemon");
		        LanguageRegistry.addName(combustiblelemonItem, "Combustible Lemon");
		        
		        OreDictionary.registerOre("cropLemon", PamHCLemon.lemonItem);

		
		


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLemon.lemonItem, 2), "cropLemon", "cropLemon"));

		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLemon.combustiblelemonItem, 1), "cropLemon", Item.gunpowder, Item.gunpowder, Item.gunpowder, Item.gunpowder, Item.gunpowder));
		
		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCLemon.pamlemonSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCLemon.lemonItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCLemon.pamlemonStorage, "cropLemon", "cropLemon", "cropLemon", "cropLemon", "cropLemon", "cropLemon", "cropLemon", "cropLemon", "cropLemon"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLemon.lemonItem, 9), pamlemonStorage));
		
		GameRegistry.registerWorldGenerator(new PamLemonGenerator());
	 
	 }


}