package mods.PamHarvestCraft.trees.coconut;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCoconut", name = "Pam's HarvestCraft Coconut", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCoconut
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.coconut.ClientProxyPamHCCoconut", serverSide = "mods.PamHarvestCraft.trees.coconut.CommonProxyPamHCCoconut")
	public static CommonProxyPamHCCoconut proxy;
	
	public static int coconutblockID = 3962;
	public static int coconutsaplingID = 3963;
	public static int coconutstorageID = 3964;
	
	public static int coconutID = 15706;
	public static int toastedcoconutID = 15707;
	
	public static int coconutcropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamCoconutBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			coconutblockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "coconutblockID", 3962).getInt();
			coconutsaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "coconutsaplingID", 3963).getInt();
			coconutstorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "coconutstorageID", 3964).getInt();
			coconutID = cfg.get(cfg.CATEGORY_ITEM, "coconutID", 15706).getInt();
			toastedcoconutID = cfg.get(cfg.CATEGORY_ITEM, "toastedcoconutID", 15707).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			coconutcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"coconutcropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCoconut has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamCoconut;
    public static Block pamcoconutSapling;
    public static Block pamcoconutStorage;
    
    public static Item coconutItem;
    public static Item toastedcoconutItem;
    
    public static ItemStack coconut_0;
    public static ItemStack coconut_1;
    public static ItemStack coconut_2;
    
    public static ItemStack coconutSapling;
    public static ItemStack coconutStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamCoconut = new BlockPamCoconut(coconutblockID, "coconut");
		pamcoconutSapling = new BlockPamCoconutSapling(coconutsaplingID).setUnlocalizedName("PamHarvestCraft:coconutSapling");
		pamcoconutStorage = new BlockPamStorage(coconutstorageID, 0).setUnlocalizedName("PamHarvestCraft:coconutStorage");
		
		coconutItem = new ItemPamFood(coconutID, coconutcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:coconutItem");
		toastedcoconutItem = new ItemPamFood(toastedcoconutID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:toastedcoconutItem");
		
		MinecraftForge.addGrassPlant(pamcoconutSapling, 0, 25);
		
		ModLoader.registerBlock(pamCoconut, ItemPamCoconut.class);
		ModLoader.registerBlock(pamcoconutSapling);
		ModLoader.registerBlock(pamcoconutStorage);
		
		//Block Names
		coconut_0 = new ItemStack(pamCoconut, 1, 0);
		coconut_1 = new ItemStack(pamCoconut, 1, 1);
		coconut_2 = new ItemStack(pamCoconut, 1, 2);
        
        coconutSapling = new ItemStack(pamcoconutSapling, 1, 0);
        coconutStorage = new ItemStack(pamcoconutStorage, 1, 0);
        
        LanguageRegistry.addName(coconut_0, "Very Unripe Coconut");
        LanguageRegistry.addName(coconut_1, "Unripe Coconut");
        LanguageRegistry.addName(coconut_2, "Ripe Coconut");
        
        LanguageRegistry.addName(coconutSapling, "Coconut Sapling");
        LanguageRegistry.addName(coconutStorage, "Coconut Crate");
        
        LanguageRegistry.addName(coconutItem, "Coconut");
        LanguageRegistry.addName(toastedcoconutItem, "Toasted Coconut");
        
        OreDictionary.registerOre("cropCoconut", PamHCCoconut.coconutItem);
        OreDictionary.registerOre("foodToastedcoconut", PamHCCoconut.toastedcoconutItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCCoconut.pamcoconutSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCCoconut.coconutItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCoconut.pamcoconutStorage, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem, PamHCCoconut.coconutItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCoconut.coconutItem, 9), pamcoconutStorage));
		
		GameRegistry.addSmelting(PamHCCoconut.coconutItem.itemID, new ItemStack(PamHCCoconut.toastedcoconutItem.itemID, 1, 0), 0.1F);
		
		GameRegistry.registerWorldGenerator(new PamCoconutGenerator());
	 
	 }

}