package mods.PamHarvestCraft.trees.coconut;

import java.util.List;
import java.util.Random;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockPamCoconut extends Block
{
	public Icon[] icons;
	
	private String fruit;
	
	private static int blockid;
	
    public BlockPamCoconut(int i, String fruit)
    {
        super(i, Material.circuits);
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        this.setStepSound(Block.soundGrassFootstep);
        this.fruit = fruit;
        this.blockid = i;
        
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k)
    {
        return null;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister)
    {
        this.icons = new Icon[3];

        for (int i = 0; i < this.icons.length; ++i)
        {
            this.icons[i] = par1IconRegister.registerIcon("PamHarvestCraft:"+fruit+"_" + i);
        }
    }
    
    @Override
    @SideOnly(Side.CLIENT)
    public Icon getBlockTextureFromSideAndMetadata(int par1, int par2)
    {
        return this.icons[par2];
    }
    
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random)
    {
        super.updateTick(par1World, par2, par3, par4, par5Random);

            int var6 = par1World.getBlockMetadata(par2, par3, par4);

            if (var6 < 2)
            {
                if (par5Random.nextInt(30) == 0)
                {
                    ++var6;
                    par1World.setBlock(par2, par3, par4, blockid, var6, 2);
                }
            }
    }
    
    /**
     * Apply bonemeal to the crops.
     */
    public void fertilize(World par1World, int par2, int par3, int par4)
    {
        int l = par1World.getBlockMetadata(par2, par3, par4) + MathHelper.getRandomIntegerInRange(par1World.rand, 2, 5);

        if (l > 2)
        {
            l = 2;
        }

        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);

    }
    
    public int idDropped(int i, Random random, int j)
    {

        if (j == 2)
        {
            return PamHCCoconut.coconutItem.itemID;
        }
        if (i == 2)
        {
        	return PamHCCoconut.coconutItem.itemID;
        }

        
		return j;
    }


    public boolean canPlaceBlockAt(World world, int i, int j, int k)
    {
        int l = world.getBlockId(i, j + 1, k);
        return l == 18;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l)
    {
        h(world, i, j, k);
    }

    protected final void h(World world, int i, int j, int k)
    {
        if (!canBlockStay(world, i, j, k))
        {
            //dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k), 1);
            world.setBlock(i, j, k, 0);
        }
    }

    public boolean canBlockStay(World world, int i, int j, int k)
    {
        return canPlaceBlockAt(world, i, j, k);
    }

    public boolean isOpaqueCube()
    {
        return false;
    }

    public boolean renderAsNormalBlock()
    {
        return false;
    }

    public int getRenderType()
    {
        return 1;
    }

    public float getBlockHardness(World par1World, int par2, int par3, int par4) 
    {
    	int meta = par1World.getBlockMetadata(par2, par3, par4);
    	if(meta == 2) return 0.0F;
    	else return 5.0F;
    	}


    public void onBlockDestroyedByPlayer(World world, int par2, int par3, int par4, int par5)
    {
    	if (par5 == 2)
    	{
    		world.setBlock(par2, par3, par4, blockid, 0, 2);
    	}
    }
    
    public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));

    }
    
}