package mods.PamHarvestCraft.trees.cinnamon;

import java.util.Map;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCinnamon", name = "Pam's HarvestCraft Cinnamon", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCinnamon
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.cinnamon.ClientProxyPamHCCinnamon", serverSide = "mods.PamHarvestCraft.trees.cinnamon.CommonProxyPamHCCinnamon")
	public static CommonProxyPamHCCinnamon proxy;
	
	public static int cinnamonblockID = 3968;
	public static int cinnamonsaplingID = 3969;
	public static int cinnamonstorageID = 3970;
	
	public static int cinnamonID = 15709;
	
	public static int cinnamoncropfoodrestore = 1;
	public static int treerarity = 2;
	
	
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamCinnamonBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			cinnamonblockID = cfg.get(cfg.CATEGORY_BLOCK, "cinnamonblockID", 3968).getInt();
			cinnamonsaplingID = cfg.get(cfg.CATEGORY_BLOCK,"cinnamonsaplingID", 3969).getInt();
			cinnamonstorageID = cfg.get(cfg.CATEGORY_BLOCK,"cinnamonstorageID", 3970).getInt();
			cinnamonID = cfg.get(cfg.CATEGORY_ITEM,"cinnamonID", 15709).getInt();
			cinnamoncropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"cinnamoncropfoodrestore",  1).getInt();
			treerarity = cfg.get(cfg.CATEGORY_ITEM,"treerarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCinnamon has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
		
	}
    
    public static Block pamCinnamon;
    public static Block pamcinnamonSapling;
    public static Block pamcinnamonStorage;
    
    public static Item cinnamonItem;
    
    public static ItemStack cinnamon_0;
    public static ItemStack cinnamon_1;
    public static ItemStack cinnamon_2;
    
    public static ItemStack cinnamonSapling;
    public static ItemStack cinnamonStorage;
    

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();

		pamCinnamon = new BlockPamCinnamon(cinnamonblockID, "cinnamon");
		pamcinnamonSapling = new BlockPamCinnamonSapling(cinnamonsaplingID).setUnlocalizedName("PamHarvestCraft:cinnamonSapling");
		pamcinnamonStorage = new BlockPamStorage(cinnamonstorageID, 0).setUnlocalizedName("PamHarvestCraft:cinnamonStorage");
		
		cinnamonItem = new ItemPamFood(cinnamonID, cinnamoncropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:cinnamonItem");
		
		MinecraftForge.addGrassPlant(pamcinnamonSapling, 0, 25);
		
		ModLoader.registerBlock(pamCinnamon, ItemPamCinnamon.class);
		ModLoader.registerBlock(pamcinnamonSapling);
		ModLoader.registerBlock(pamcinnamonStorage);
		
		//Block Names
				cinnamon_0 = new ItemStack(pamCinnamon, 1, 0);
				cinnamon_1 = new ItemStack(pamCinnamon, 1, 1);
				cinnamon_2 = new ItemStack(pamCinnamon, 1, 2);
		        
		        cinnamonSapling = new ItemStack(pamcinnamonSapling, 1, 0);
		        cinnamonStorage = new ItemStack(pamcinnamonStorage, 1, 0);
		        
		        LanguageRegistry.addName(cinnamon_0, "Very Unripe Cinnamon");
		        LanguageRegistry.addName(cinnamon_1, "Unripe Cinnamon");
		        LanguageRegistry.addName(cinnamon_2, "Ripe Cinnamon");
		        
		        LanguageRegistry.addName(cinnamonSapling, "Cinnamon Sapling");
		        LanguageRegistry.addName(cinnamonStorage, "Cinnamon Crate");
		LanguageRegistry.addName(cinnamonItem, "Cinnamon");

		OreDictionary.registerOre("cropCinnamon", PamHCCinnamon.cinnamonItem);


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCinnamon.cinnamonItem, 2), "cropCinnamon", "cropCinnamon"));

		
		ModLoader.addShapelessRecipe(new ItemStack(PamHCCinnamon.pamcinnamonSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCCinnamon.cinnamonItem), new ItemStack(Block.sapling, 1, 0)
                });
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCinnamon.pamcinnamonStorage, "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon", "cropCinnamon"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCinnamon.cinnamonItem, 9), pamcinnamonStorage));
		
		GameRegistry.registerWorldGenerator(new PamCinnamonGenerator());
	 
	 }


}