package mods.PamHarvestCraft.trees.cinnamon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemPamCinnamon extends ItemBlock
{
    public ItemPamCinnamon(int i)
    {
        super(i);
        setMaxDamage(0);
        setHasSubtypes(true);
    }


    @Override
    @SideOnly(Side.CLIENT)
    public Icon getIconFromDamage(int i)
    {
        return PamHCCinnamon.pamCinnamon.getBlockTextureFromSideAndMetadata(2, i);
    }

    public int getMetadata(int par1)
    {
        return par1;
    }
    
    @Override
    public String getUnlocalizedName(ItemStack var1)
    {
        int var2 = var1.getItemDamage();
        switch (var2)
        {
            case 0:
                return "cinnamon_0";
            case 1:
                return "cinnamon_1";
            case 2:
                return "cinnamon_2";
            default:
                return null;
        }
    }
}
