package mods.PamHarvestCraft.trees.cherry;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCherry", name = "Pam's HarvestCraft Cherry", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCherry
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.cherry.ClientProxyPamHCCherry", serverSide = "mods.PamHarvestCraft.trees.cherry.CommonProxyPamHCCherry")
	public static CommonProxyPamHCCherry proxy;
	
	public static int cherryblockID = 4090;
	public static int cherrysaplingID = 4091;
	public static int cherrystorageID = 4092;
	public static int cherryID = 15576;
	
	public static int cherrycropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamCherryBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			cherryblockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "cherryblockID", 4090).getInt();
			cherrysaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "cherrysaplingID", 4091).getInt();
			cherrystorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "cherrystorageID", 4092).getInt();
			cherryID = cfg.get(cfg.CATEGORY_ITEM, "cherryID", 15576).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			cherrycropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"cherrycropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCherry has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamCherry;
    public static Block pamcherrySapling;
    public static Block pamcherryStorage;
    
    public static Item cherryItem;
    
    public static ItemStack cherry_0;
    public static ItemStack cherry_1;
    public static ItemStack cherry_2;
    
    public static ItemStack cherrySapling;
    public static ItemStack cherryStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamCherry = new BlockPamCherry(cherryblockID, "cherry");
		pamcherrySapling = new BlockPamCherrySapling(cherrysaplingID).setUnlocalizedName("PamHarvestCraft:cherrySapling");
		pamcherryStorage = new BlockPamStorage(cherrystorageID, 0).setUnlocalizedName("PamHarvestCraft:cherryStorage");
		
		cherryItem = new ItemPamFood(cherryID, cherrycropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:cherryItem");
		
		MinecraftForge.addGrassPlant(pamcherrySapling, 0, 25);
		
		ModLoader.registerBlock(pamCherry, ItemPamCherry.class);
		ModLoader.registerBlock(pamcherrySapling);
		ModLoader.registerBlock(pamcherryStorage);
		
		//Block Names
		cherry_0 = new ItemStack(pamCherry, 1, 0);
		cherry_1 = new ItemStack(pamCherry, 1, 1);
		cherry_2 = new ItemStack(pamCherry, 1, 2);
        
        cherrySapling = new ItemStack(pamcherrySapling, 1, 0);
        cherryStorage = new ItemStack(pamcherryStorage, 1, 0);
        
        LanguageRegistry.addName(cherry_0, "Very Unripe Cherry");
        LanguageRegistry.addName(cherry_1, "Unripe Cherry");
        LanguageRegistry.addName(cherry_2, "Ripe Cherry");
        
        LanguageRegistry.addName(cherrySapling, "Cherry Sapling");
        LanguageRegistry.addName(cherryStorage, "Cherry Crate");
        
        LanguageRegistry.addName(cherryItem, "Cherry");
        
        OreDictionary.registerOre("cropCherry", PamHCCherry.cherryItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCCherry.pamcherrySapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCCherry.cherryItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCherry.pamcherryStorage, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem, PamHCCherry.cherryItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCherry.cherryItem, 9), pamcherryStorage));
		
		GameRegistry.registerWorldGenerator(new PamCherryGenerator());
	 
	 }

}