package mods.PamHarvestCraft.trees.banana;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenPamBanana extends WorldGenerator
{
	private int metaWood = 3;
	private int metaLeaves = 3;
	
    public WorldGenPamBanana(int i)
    {
        treeType = i;
    }

    public boolean generate(World world, Random random, int x, int y, int z)
    {
    	int treeHeight = random.nextInt(2) + 3;
        boolean flag = true;

        // One super long check to see if the tree can spawn here
        if (y < 1 || y + treeHeight + 1 > 256)
        {
            return false;
        }

        for (int i1 = y; i1 <= y + 1 + treeHeight; i1++)
        {
            byte byte0 = 1;

            if (i1 == y)
            {
                byte0 = 0;
            }

            if (i1 >= (y + 1 + treeHeight) - 2)
            {
                byte0 = 2;
            }

            for (int i2 = x - byte0; i2 <= x + byte0 && flag; i2++)
            {
                for (int l2 = z - byte0; l2 <= z + byte0 && flag; l2++)
                {
                    if (i1 >= 0 && i1 < 128)
                    {
                        int j3 = world.getBlockId(i2, i1, l2);

                        if (j3 != 0 && j3 != 18)
                        {
                            flag = false;
                        }
                    }
                    else
                    {
                        flag = false;
                    }
                }
            }
        }

        if (!flag)
        {
            return false;
        }

        int j1 = world.getBlockId(x, y - 1, z);

        if (j1 != Block.grass.blockID && j1 != Block.dirt.blockID || y >= 256 - treeHeight - 1)
        {
            return false;
        }

        // Here's where the tree starts generating
        world.setBlock(x, y - 1, z, Block.dirt.blockID); // If the block below the tree is a grass block, change it to a dirt block.

                    this.setBlockAndMetadata(world, x, y + treeHeight + 2, z, Block.leaves.blockID, this.metaLeaves);//top block of leaves
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z, Block.wood.blockID, this.metaWood);//wood under that
                    this.setBlockAndMetadata(world, x, y + treeHeight, z, Block.wood.blockID, this.metaWood);//wood under that
                    
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z + 1, Block.leaves.blockID, this.metaLeaves);//straight arm of palm
                    this.setBlockAndMetadata(world, x, y + treeHeight, z + 1, PamHCBanana.pamBanana.blockID, 0);
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z + 2, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z + 3, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x, y + treeHeight, z + 4, Block.leaves.blockID, this.metaLeaves);
                    
                    this.setBlockAndMetadata(world, x + 1, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);//straight arm of palm
                    this.setBlockAndMetadata(world, x + 1, y + treeHeight, z, PamHCBanana.pamBanana.blockID, 0);
                    this.setBlockAndMetadata(world, x + 2, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x + 3, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x + 4, y + treeHeight, z, Block.leaves.blockID, this.metaLeaves);
                    
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z - 1, Block.leaves.blockID, this.metaLeaves);//straight arm of palm
                    this.setBlockAndMetadata(world, x, y + treeHeight, z - 1, PamHCBanana.pamBanana.blockID, 0);
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z - 2, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x, y + treeHeight + 1, z - 3, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x, y + treeHeight, z - 4, Block.leaves.blockID, this.metaLeaves);
                    
                    this.setBlockAndMetadata(world, x - 1, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);//straight arm of palm
                    this.setBlockAndMetadata(world, x - 1, y + treeHeight, z, PamHCBanana.pamBanana.blockID, 0);
                    this.setBlockAndMetadata(world, x - 2, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x - 3, y + treeHeight + 1, z, Block.leaves.blockID, this.metaLeaves);
                    this.setBlockAndMetadata(world, x - 4, y + treeHeight, z, Block.leaves.blockID, this.metaLeaves);
                    
                    
                    this.setBlockAndMetadata(world, x - 1, y + treeHeight + 1, z - 1, Block.leaves.blockID, this.metaLeaves );//diagonal arm of palm
                    this.setBlockAndMetadata(world, x - 1, y + treeHeight + 1, z + 1, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x + 1, y + treeHeight + 1, z - 1, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x + 1, y + treeHeight + 1, z + 1, Block.leaves.blockID, this.metaLeaves );
                    
                    this.setBlockAndMetadata(world, x + 2, y + treeHeight + 1, z + 2, Block.leaves.blockID, this.metaLeaves );//diagonal arm of palm
                    this.setBlockAndMetadata(world, x + 2, y + treeHeight + 1, z - 2, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x - 2, y + treeHeight + 1, z + 2, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x - 2, y + treeHeight + 1, z - 2, Block.leaves.blockID, this.metaLeaves );
               
                    this.setBlockAndMetadata(world, x + 3, y + treeHeight, z + 3, Block.leaves.blockID, this.metaLeaves );//diagonal arm of palm
                    this.setBlockAndMetadata(world, x + 3, y + treeHeight, z - 3, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x - 3, y + treeHeight, z + 3, Block.leaves.blockID, this.metaLeaves );
                    this.setBlockAndMetadata(world, x - 3, y + treeHeight, z - 3, Block.leaves.blockID, this.metaLeaves );

                    if (world.getBlockId(x, y - 1, z) == 0) // if the block below the leaves that were just placed is air
                    {
                        int fruitType = treeType;

                        if (world.getBlockId(x, y - 2, z) == 0 && y > (y - 3) + treeHeight)
                        {
                            // If the leaves placed are not the lowest possible leaves in the tree, 100% chance to spawn fruit (makes fruit positions look varied)
                            world.setBlock(x, y - 1, z, PamHCBanana.pamBanana.blockID, fruitType, 2);
                        }
                        else
                        {
                            // else, 33% chance of spawning fruit
                            if (random.nextInt(4) == 2)
                            {
                                world.setBlock(x, y - 1, z, PamHCBanana.pamBanana.blockID, fruitType, 2);
                            }
                        }
                    }


        // This part generates the vertical line of logs that make up the tree.
        for (int l1 = 0; l1 < treeHeight; l1++)
        {
            int k2 = world.getBlockId(x, y + l1, z);

            if (k2 == 0 || k2 == 18 || k2 == PamHCBanana.pamBanana.blockID)
            {
            	this.setBlockAndMetadata(world, x, y + l1, z, Block.wood.blockID, this.metaWood );
            }
        }

        return true;
    }

    public int treeType;
}
