package mods.PamHarvestCraft.trees.banana;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCBanana", name = "Pam's HarvestCraft Banana", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCBanana
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.banana.ClientProxyPamHCBanana", serverSide = "mods.PamHarvestCraft.trees.banana.CommonProxyPamHCBanana")
	public static CommonProxyPamHCBanana proxy;
	
	public static int bananablockID = 3959;
	public static int bananasaplingID = 3960;
	public static int bananastorageID = 3961;
	
	public static int bananaID = 15705;
	
	public static int bananacropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamBananaBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			bananablockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "bananablockID", 3959).getInt();
			bananasaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "bananasaplingID", 3960).getInt();
			bananastorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "bananastorageID", 3961).getInt();
			bananaID = cfg.get(cfg.CATEGORY_ITEM, "bananaID", 15705).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			bananacropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"bananacropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCBanana has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamBanana;
    public static Block pambananaSapling;
    public static Block pambananaStorage;
    
    public static Item bananaItem;
    
    public static ItemStack banana_0;
    public static ItemStack banana_1;
    public static ItemStack banana_2;
    
    public static ItemStack bananaSapling;
    public static ItemStack bananaStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamBanana = new BlockPamBanana(bananablockID, "banana");
		pambananaSapling = new BlockPamBananaSapling(bananasaplingID).setUnlocalizedName("PamHarvestCraft:bananaSapling");
		pambananaStorage = new BlockPamStorage(bananastorageID, 0).setUnlocalizedName("PamHarvestCraft:bananaStorage");
		
		bananaItem = new ItemPamFood(bananaID, bananacropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:bananaItem");
		
		MinecraftForge.addGrassPlant(pambananaSapling, 0, 25);
		
		ModLoader.registerBlock(pamBanana, ItemPamBanana.class);
		ModLoader.registerBlock(pambananaSapling);
		ModLoader.registerBlock(pambananaStorage);
		
		//Block Names
		banana_0 = new ItemStack(pamBanana, 1, 0);
		banana_1 = new ItemStack(pamBanana, 1, 1);
		banana_2 = new ItemStack(pamBanana, 1, 2);
        
        bananaSapling = new ItemStack(pambananaSapling, 1, 0);
        bananaStorage = new ItemStack(pambananaStorage, 1, 0);
        
        LanguageRegistry.addName(banana_0, "Very Unripe Banana");
        LanguageRegistry.addName(banana_1, "Unripe Banana");
        LanguageRegistry.addName(banana_2, "Ripe Banana");
        
        LanguageRegistry.addName(bananaSapling, "Banana Sapling");
        LanguageRegistry.addName(bananaStorage, "Banana Crate");
        
        LanguageRegistry.addName(bananaItem, "Banana");
        
        OreDictionary.registerOre("cropBanana", PamHCBanana.bananaItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCBanana.pambananaSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCBanana.bananaItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCBanana.pambananaStorage, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem, PamHCBanana.bananaItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCBanana.bananaItem, 9), pambananaStorage));
		
		GameRegistry.registerWorldGenerator(new PamBananaGenerator());
	 
	 }

}