package mods.PamHarvestCraft.trees.avocado;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCAvocado", name = "Pam's HarvestCraft Avocado", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCAvocado
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.trees.avocado.ClientProxyPamHCAvocado", serverSide = "mods.PamHarvestCraft.trees.avocado.CommonProxyPamHCAvocado")
	public static CommonProxyPamHCAvocado proxy;
	
	public static int avocadoblockID = 3953;
	public static int avocadosaplingID = 3954;
	public static int avocadostorageID = 3955;
	public static int avocadoID = 15703;
	
	public static int avocadocropfoodrestore = 1;
	public static int treerarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamAvocadoBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			avocadoblockID = cfg.getBlock(cfg.CATEGORY_BLOCK, "avocadoblockID", 3953).getInt();
			avocadosaplingID = cfg.getBlock(cfg.CATEGORY_BLOCK, "avocadosaplingID", 3954).getInt();
			avocadostorageID = cfg.getBlock(cfg.CATEGORY_BLOCK, "avocadostorageID", 3955).getInt();
			avocadoID = cfg.get(cfg.CATEGORY_ITEM, "avocadoID", 15703).getInt();
			treerarity = cfg.get(cfg.CATEGORY_GENERAL, "treerarity", 2).getInt();
			avocadocropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"avocadocropfoodrestore",  1).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCAvocado has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
    public static Block pamAvocado;
    public static Block pamavocadoSapling;
    public static Block pamavocadoStorage;
    
    public static Item avocadoItem;
    
    public static ItemStack avocado_0;
    public static ItemStack avocado_1;
    public static ItemStack avocado_2;
    
    public static ItemStack avocadoSapling;
    public static ItemStack avocadoStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamAvocado = new BlockPamAvocado(avocadoblockID, "avocado");
		pamavocadoSapling = new BlockPamAvocadoSapling(avocadosaplingID).setUnlocalizedName("PamHarvestCraft:avocadoSapling");
		pamavocadoStorage = new BlockPamStorage(avocadostorageID, 0).setUnlocalizedName("PamHarvestCraft:avocadoStorage");
		
		avocadoItem = new ItemPamFood(avocadoID, avocadocropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:avocadoItem");
		
		MinecraftForge.addGrassPlant(pamavocadoSapling, 0, 25);
		
		ModLoader.registerBlock(pamAvocado, ItemPamAvocado.class);
		ModLoader.registerBlock(pamavocadoSapling);
		ModLoader.registerBlock(pamavocadoStorage);
		
		//Block Names
		avocado_0 = new ItemStack(pamAvocado, 1, 0);
		avocado_1 = new ItemStack(pamAvocado, 1, 1);
		avocado_2 = new ItemStack(pamAvocado, 1, 2);
        
        avocadoSapling = new ItemStack(pamavocadoSapling, 1, 0);
        avocadoStorage = new ItemStack(pamavocadoStorage, 1, 0);
        
        LanguageRegistry.addName(avocado_0, "Very Unripe Avocado");
        LanguageRegistry.addName(avocado_1, "Unripe Avocado");
        LanguageRegistry.addName(avocado_2, "Ripe Avocado");
        
        LanguageRegistry.addName(avocadoSapling, "Avocado Sapling");
        LanguageRegistry.addName(avocadoStorage, "Avocado Crate");
        
        LanguageRegistry.addName(avocadoItem, "Avocado");
        
        OreDictionary.registerOre("cropAvocado", PamHCAvocado.avocadoItem);

		ModLoader.addShapelessRecipe(new ItemStack(PamHCAvocado.pamavocadoSapling, 1, 0), new Object[]
                {
                    new ItemStack(PamHCAvocado.avocadoItem), new ItemStack(Block.sapling, 1, 0)
                });
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCAvocado.pamavocadoStorage, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem, PamHCAvocado.avocadoItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCAvocado.avocadoItem, 9), pamavocadoStorage));
		
		GameRegistry.registerWorldGenerator(new PamAvocadoGenerator());
	 
	 }

}