package mods.PamHarvestCraft.crops.zucchini;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCZucchini", name = "Pam's HarvestCraft Zucchini", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCZucchini
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.zucchini.ClientProxyPamHCZucchini", serverSide = "mods.PamHarvestCraft.crops.zucchini.CommonProxyPamHCZucchini")
	public static CommonProxyPamHCZucchini proxy;
	
	public static int zucchinicropID = 3808;
	public static int zucchinistorageID = 3809;
	public static int zucchiniID = 15738;
	public static int zucchiniseedID = 15739;
	public static int zucchiniseedpacketID = 15740;
	public static int zucchiniseedboxID = 15741;

	
	public static boolean seeddropfromgrass = true;
	public static int zucchinicropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamZucchiniBonemealEvent());
		try {
			cfg.load();
			zucchinicropID = cfg.get(cfg.CATEGORY_BLOCK, "zucchinicropID", 3808).getInt();
			zucchinistorageID = cfg.get(cfg.CATEGORY_BLOCK, "zucchinistorageID", 3809).getInt();
			zucchiniID = cfg.get(cfg.CATEGORY_ITEM, "zucchiniID", 15738).getInt();
			zucchiniseedID = cfg.get(cfg.CATEGORY_ITEM, "zucchiniseedID", 15739).getInt();
			zucchiniseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "zucchiniseedpacketID", 15740).getInt();
			zucchiniseedboxID = cfg.get(cfg.CATEGORY_ITEM, "zucchiniseedboxID", 15741).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			zucchinicropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "zucchinicropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCZucchini has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamzucchiniCrop;
	public static Block pamzucchiniStorage;
	public static Item zucchiniItem;
	public static Item zucchiniseedItem;
	public static Item zucchiniseedpacketItem;
	public static Item zucchiniseedboxItem;
	
	public static ItemStack zucchiniStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamzucchiniCrop = new BlockPamZucchiniCrop(zucchinicropID, "zucchini", 0);
		pamzucchiniStorage = new BlockPamStorage(zucchinistorageID, 0).setUnlocalizedName("PamHarvestCraft:zucchiniStorage");
		
		zucchiniItem = new ItemPamFood(zucchiniID, zucchinicropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:zucchiniItem");
		zucchiniseedItem = new ItemPamSeed(zucchiniseedID, PamHCZucchini.pamzucchiniCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:zucchiniseedItem");
		zucchiniseedpacketItem = new ItemPam(zucchiniseedpacketID).setUnlocalizedName("PamHarvestCraft:zucchiniseedpacketItem");
		zucchiniseedboxItem = new ItemPam(zucchiniseedboxID).setUnlocalizedName("PamHarvestCraft:zucchiniseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(zucchiniseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamzucchiniCrop);
		ModLoader.registerBlock(pamzucchiniStorage);
		
		zucchiniStorage = new ItemStack(pamzucchiniStorage, 1, 0);

		LanguageRegistry.addName(zucchiniItem, "Zucchini");
		LanguageRegistry.addName(zucchiniseedItem, "Zucchini Seed");
		LanguageRegistry.addName(zucchiniseedpacketItem, "Zucchini Seed Packet");
		LanguageRegistry.addName(zucchiniseedboxItem, "Zucchini Seed Box");
		
		LanguageRegistry.addName(zucchiniStorage, "Zucchini Crate");

	    
		OreDictionary.registerOre("cropZucchini", PamHCZucchini.zucchiniItem);
		OreDictionary.registerOre("seedZucchini", PamHCZucchini.zucchiniseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCZucchini.zucchiniseedItem, zucchiniItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCZucchini.zucchiniItem, 2), "cropZucchini", "cropZucchini"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCZucchini.pamzucchiniStorage, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem, zucchiniItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCZucchini.zucchiniItem, 9), pamzucchiniStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCZucchini.zucchiniseedpacketItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem, zucchiniseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCZucchini.zucchiniseedItem, 8), zucchiniseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCZucchini.zucchiniseedboxItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem, zucchiniseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCZucchini.zucchiniseedpacketItem, 8), zucchiniseedboxItem));
		

	 
	 }

}