package mods.PamHarvestCraft.crops.turnip;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCTurnip", name = "Pam's HarvestCraft Turnip", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCTurnip
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.turnip.ClientProxyPamHCTurnip", serverSide = "mods.PamHarvestCraft.crops.turnip.CommonProxyPamHCTurnip")
	public static CommonProxyPamHCTurnip proxy;
	
	public static int turnipcropID = 3822;
	public static int turnipstorageID = 3823;
	public static int turnipID = 15766;
	public static int turnipseedID = 15767;
	public static int turnipseedpacketID = 15768;
	public static int turnipseedboxID = 15769;

	
	public static boolean seeddropfromgrass = true;
	public static int turnipcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamTurnipBonemealEvent());
		try {
			cfg.load();
			turnipcropID = cfg.get(cfg.CATEGORY_BLOCK, "turnipcropID", 3822).getInt();
			turnipstorageID = cfg.get(cfg.CATEGORY_BLOCK, "turnipstorageID", 3823).getInt();
			turnipID = cfg.get(cfg.CATEGORY_ITEM, "turnipID", 15766).getInt();
			turnipseedID = cfg.get(cfg.CATEGORY_ITEM, "turnipseedID", 15767).getInt();
			turnipseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "turnipseedpacketID", 15768).getInt();
			turnipseedboxID = cfg.get(cfg.CATEGORY_ITEM, "turnipseedboxID", 15769).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			turnipcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "turnipcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCTurnip has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamturnipCrop;
	public static Block pamturnipStorage;
	public static Item turnipItem;
	public static Item turnipseedItem;
	public static Item turnipseedpacketItem;
	public static Item turnipseedboxItem;
	
	public static ItemStack turnipStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamturnipCrop = new BlockPamTurnipCrop(turnipcropID, "turnip", 0);
		pamturnipStorage = new BlockPamStorage(turnipstorageID, 0).setUnlocalizedName("PamHarvestCraft:turnipStorage");
		
		turnipItem = new ItemPamSeedFood(turnipID, turnipcropfoodrestore, 1.2F, PamHCTurnip.pamturnipCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:turnipItem");
		turnipseedItem = new ItemPamSeed(turnipseedID, PamHCTurnip.pamturnipCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:turnipseedItem");
		turnipseedpacketItem = new ItemPam(turnipseedpacketID).setUnlocalizedName("PamHarvestCraft:turnipseedpacketItem");
		turnipseedboxItem = new ItemPam(turnipseedboxID).setUnlocalizedName("PamHarvestCraft:turnipseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(turnipseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamturnipCrop);
		ModLoader.registerBlock(pamturnipStorage);
		
		turnipStorage = new ItemStack(pamturnipStorage, 1, 0);

		LanguageRegistry.addName(turnipItem, "Turnip");
		LanguageRegistry.addName(turnipseedItem, "Turnip Seed");
		LanguageRegistry.addName(turnipseedpacketItem, "Turnip Seed Packet");
		LanguageRegistry.addName(turnipseedboxItem, "Turnip Seed Box");
		
		LanguageRegistry.addName(turnipStorage, "Turnip Crate");

	    
		OreDictionary.registerOre("cropTurnip", PamHCTurnip.turnipItem);
		OreDictionary.registerOre("seedTurnip", PamHCTurnip.turnipseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTurnip.turnipseedItem, turnipItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTurnip.turnipItem, 2), "cropTurnip", "cropTurnip"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTurnip.pamturnipStorage, turnipItem, turnipItem, turnipItem, turnipItem, turnipItem, turnipItem, turnipItem, turnipItem, turnipItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTurnip.turnipItem, 9), pamturnipStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTurnip.turnipseedpacketItem, turnipseedItem, turnipseedItem, turnipseedItem, turnipseedItem, turnipseedItem, turnipseedItem, turnipseedItem, turnipseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTurnip.turnipseedItem, 8), turnipseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTurnip.turnipseedboxItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem, turnipseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTurnip.turnipseedpacketItem, 8), turnipseedboxItem));
		

	 
	 }

}