package mods.PamHarvestCraft.crops.tomato;

import java.io.File;
import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.structure.ComponentVillageField;
import net.minecraft.world.gen.structure.StructureVillagePieceWeight;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;

import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;

@Mod(modid = "PamHCTomato", name = "Pam's HarvestCraft Tomato", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCTomato
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.tomato.ClientProxyPamHCTomato", serverSide = "mods.PamHarvestCraft.crops.tomato.CommonProxyPamHCTomato")
	public static CommonProxyPamHCTomato proxy;
	
	public static int tomatocropID = 4020;
	public static int tomatostorageID = 4021;
	public static int tomatoID = 15200;
	public static int tomatoseedID = 15201;
	public static int tomatoseedpacketID = 15202;
	public static int tomatoseedboxID = 15203;

	
	public static boolean seeddropfromgrass = true;
	public static int tomatocropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamTomatoBonemealEvent());

		try {
			cfg.load();
			tomatocropID = cfg.get(cfg.CATEGORY_BLOCK, "tomatocropID", 4020).getInt();
			tomatostorageID = cfg.get(cfg.CATEGORY_BLOCK, "tomatostorageID", 4021).getInt();
			tomatoID = cfg.get(cfg.CATEGORY_ITEM, "tomatoID", 15200).getInt();
			tomatoseedID = cfg.get(cfg.CATEGORY_ITEM, "tomatoseedID", 15201).getInt();
			tomatoseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "tomatoseedpacketID", 15202).getInt();
			tomatoseedboxID = cfg.get(cfg.CATEGORY_ITEM, "tomatoseedboxID", 15203).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			tomatocropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "tomatocropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCTomato has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamtomatoCrop;
	public static Block pamtomatoStorage;
	public static Item tomatoItem;
	public static Item tomatoseedItem;
	public static Item tomatoseedpacketItem;
	public static Item tomatoseedboxItem;
	
	public static ItemStack tomatoStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamtomatoCrop = new BlockPamTomatoCrop(tomatocropID, "tomato", 0);
		pamtomatoStorage = new BlockPamStorage(tomatostorageID, 0).setUnlocalizedName("PamHarvestCraft:tomatoStorage");
		
		tomatoItem = new ItemPamFood(tomatoID, tomatocropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:tomatoItem");
		tomatoseedItem = new ItemPamSeed(tomatoseedID, PamHCTomato.pamtomatoCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:tomatoseedItem");
		tomatoseedpacketItem = new ItemPam(tomatoseedpacketID).setUnlocalizedName("PamHarvestCraft:tomatoseedpacketItem");
		tomatoseedboxItem = new ItemPam(tomatoseedboxID).setUnlocalizedName("PamHarvestCraft:tomatoseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(tomatoseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamtomatoCrop);
		ModLoader.registerBlock(pamtomatoStorage);
		
		tomatoStorage = new ItemStack(pamtomatoStorage, 1, 0);

		LanguageRegistry.addName(tomatoItem, "Tomato");
		LanguageRegistry.addName(tomatoseedItem, "Tomato Seed");
		LanguageRegistry.addName(tomatoseedpacketItem, "Tomato Seed Packet");
		LanguageRegistry.addName(tomatoseedboxItem, "Tomato Seed Box");
		
		LanguageRegistry.addName(tomatoStorage, "Tomato Crate");

	    
		OreDictionary.registerOre("cropTomato", PamHCTomato.tomatoItem);
		OreDictionary.registerOre("seedTomato", PamHCTomato.tomatoseedItem);
		
		FMLInterModComms.sendMessage("Forestry", "add-farmable-crop", String.format("farmWheat@%s.%s.%s.%s", tomatoseedItem.itemID, 0, tomatocropID, 7));

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTomato.tomatoseedItem, tomatoItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTomato.tomatoItem, 2), "cropTomato", "cropTomato"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTomato.pamtomatoStorage, tomatoItem, tomatoItem, tomatoItem, tomatoItem, tomatoItem, tomatoItem, tomatoItem, tomatoItem, tomatoItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTomato.tomatoItem, 9), pamtomatoStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTomato.tomatoseedpacketItem, tomatoseedItem, tomatoseedItem, tomatoseedItem, tomatoseedItem, tomatoseedItem, tomatoseedItem, tomatoseedItem, tomatoseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTomato.tomatoseedItem, 8), tomatoseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTomato.tomatoseedboxItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem, tomatoseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTomato.tomatoseedpacketItem, 8), tomatoseedboxItem));

		//VillagerRegistry.instance().registerVillageCreationHandler(new TomatoVillageCreationHandler());
		for(int i = 0; i < 5; i++)
			VillagerRegistry.instance().registerVillageTradeHandler(i, new TomatoTradeHandler());
		
		if(Loader.isModLoaded("Thaumcraft") == true)
        {
                ThaumcraftApi.registerObjectTag(tomatoseedItem.itemID, 0, (new ObjectTags()).add(EnumTag.PLANT, 1).add(EnumTag.EXCHANGE, 1));
                ThaumcraftApi.registerObjectTag(tomatoItem.itemID, 0, (new ObjectTags()).add(EnumTag.CROP, 2).add(EnumTag.LIFE, 2));
                FMLInterModComms.sendMessage("Thaumcraft", "harvestStandardCrop", new ItemStack(PamHCTomato.tomatocropID,1,7));
        }
	 }

}