package mods.PamHarvestCraft.crops.tea;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCTea", name = "Pam's HarvestCraft Tea", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCTea
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.tea.ClientProxyPamHCTea", serverSide = "mods.PamHarvestCraft.crops.tea.CommonProxyPamHCTea")
	public static CommonProxyPamHCTea proxy;
	
	public static int teacropID = 3837;
	public static int teastorageID = 3838;
	public static int tealeafID = 15797;
	public static int teaseedID = 15798;
	public static int teaseedpacketID = 15799;
	public static int teaseedboxID = 15800;
	public static int teaID = 15801;

	
	public static boolean seeddropfromgrass = true;
	public static int teacropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamTeaBonemealEvent());
		try {
			cfg.load();
			teacropID = cfg.get(cfg.CATEGORY_BLOCK, "teacropID", 3837).getInt();
			teastorageID = cfg.get(cfg.CATEGORY_BLOCK, "teastorageID", 3838).getInt();
			tealeafID = cfg.get(cfg.CATEGORY_ITEM, "tealeafID", 15797).getInt();
			teaseedID = cfg.get(cfg.CATEGORY_ITEM, "teaseedID", 15798).getInt();
			teaseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "teaseedpacketID", 15799).getInt();
			teaseedboxID = cfg.get(cfg.CATEGORY_ITEM, "teaseedboxID", 15800).getInt();
			teaID = cfg.get(cfg.CATEGORY_ITEM, "teaID", 15801).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			teacropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "teacropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCTea has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamteaCrop;
	public static Block pamteaStorage;
	public static Item tealeafItem;
	public static Item teaseedItem;
	public static Item teaseedpacketItem;
	public static Item teaseedboxItem;
	public static Item teaItem;
	
	public static ItemStack teaStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamteaCrop = new BlockPamTeaCrop(teacropID, "tea", 0);
		pamteaStorage = new BlockPamStorage(teastorageID, 0).setUnlocalizedName("PamHarvestCraft:teaStorage");
		
		tealeafItem = new ItemPamFood(tealeafID, teacropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:tealeafItem");
		teaseedItem = new ItemPamSeed(teaseedID, PamHCTea.pamteaCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:teaseedItem");
		teaseedpacketItem = new ItemPam(teaseedpacketID).setUnlocalizedName("PamHarvestCraft:teaseedpacketItem");
		teaseedboxItem = new ItemPam(teaseedboxID).setUnlocalizedName("PamHarvestCraft:teaseedboxItem");
		teaItem = new ItemPamFood(teaID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:teaItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(teaseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamteaCrop);
		ModLoader.registerBlock(pamteaStorage);
		
		teaStorage = new ItemStack(pamteaStorage, 1, 0);

		LanguageRegistry.addName(tealeafItem, "Tea Leaf");
		LanguageRegistry.addName(teaseedItem, "Tea Seed");
		LanguageRegistry.addName(teaseedpacketItem, "Tea Seed Packet");
		LanguageRegistry.addName(teaseedboxItem, "Tea Seed Box");
		LanguageRegistry.addName(teaItem, "Cup of Tea");
		
		LanguageRegistry.addName(teaStorage, "Tea Crate");

	    
		OreDictionary.registerOre("cropTea", PamHCTea.tealeafItem);
		OreDictionary.registerOre("seedTea", PamHCTea.teaseedItem);
		OreDictionary.registerOre("foodTea", PamHCTea.teaItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTea.teaseedItem, tealeafItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTea.teaItem, 2), "cropTea", "cropTea"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTea.pamteaStorage, tealeafItem, tealeafItem, tealeafItem, tealeafItem, tealeafItem, tealeafItem, tealeafItem, tealeafItem, tealeafItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTea.tealeafItem, 9), pamteaStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTea.teaseedpacketItem, teaseedItem, teaseedItem, teaseedItem, teaseedItem, teaseedItem, teaseedItem, teaseedItem, teaseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTea.teaseedItem, 8), teaseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCTea.teaseedboxItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem, teaseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCTea.teaseedpacketItem, 8), teaseedboxItem));
		
		GameRegistry.addSmelting(PamHCTea.tealeafItem.itemID, new ItemStack(PamHCTea.teaItem, 1, 0), 0.1F);
	 
	 }

}