package mods.PamHarvestCraft.crops.tea;

import java.util.ArrayList;
import java.util.Random;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockPamTeaCrop extends BlockFlower
{
	 @SideOnly(Side.CLIENT)
	    private Icon[] field_94363_a;
	 
	 	 String veg;
	 	 
		 static int blockid;
		 

	    public BlockPamTeaCrop(int par1, String veg, int drop)
	    {
	        super(par1);
	        this.veg = veg;
	        this.blockid = par1;
	        this.setTickRandomly(true);
	        float f = 0.5F;
	        this.setBlockBounds(0.5F - f, 0.0F, 0.5F - f, 0.5F + f, 0.25F, 0.5F + f);
	        this.setCreativeTab((CreativeTabs)null);
	        this.setHardness(0.0F);
	        this.setStepSound(soundGrassFootstep);
	        this.disableStats();
	    }


		/**
	     * Gets passed in the blockID of the block below and supposed to return true if its allowed to grow on the type of
	     * blockID passed in. Args: blockID
	     */
	    protected boolean canThisPlantGrowOnThisBlockID(int par1)
	    {
	        return par1 == Block.tilledField.blockID;
	    }

	    /**
	     * Ticks the block if it's been scheduled
	     */
	    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random)
	    {
	        super.updateTick(par1World, par2, par3, par4, par5Random);

	        if (par1World.getBlockLightValue(par2, par3 + 1, par4) >= 9)
	        {
	            int l = par1World.getBlockMetadata(par2, par3, par4);

	            if (l < 7)
	            {
	                float f = this.getGrowthRate(par1World, par2, par3, par4);

	                if (par5Random.nextInt((int)(25.0F / f) + 1) == 0)
	                {
	                    ++l;
	                    par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);
	                }
	            }
	        }
	    }

	    /**
	     * Apply bonemeal to the crops.
	     */
	    public void fertilize(World par1World, int par2, int par3, int par4)
	    {
	        int l = par1World.getBlockMetadata(par2, par3, par4) + MathHelper.getRandomIntegerInRange(par1World.rand, 2, 5);

	        if (l > 7)
	        {
	            l = 7;
	        }

	        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);

	    }

	    /**
	     * Gets the growth rate for the crop. Setup to encourage rows by halving growth rate if there is diagonals, crops on
	     * different sides that aren't opposing, and by adding growth for every crop next to this one (and for crop below
	     * this one). Args: x, y, z
	     */
	    private float getGrowthRate(World par1World, int par2, int par3, int par4)
	    {
	        float f = 1.0F;
	        int l = par1World.getBlockId(par2, par3, par4 - 1);
	        int i1 = par1World.getBlockId(par2, par3, par4 + 1);
	        int j1 = par1World.getBlockId(par2 - 1, par3, par4);
	        int k1 = par1World.getBlockId(par2 + 1, par3, par4);
	        int l1 = par1World.getBlockId(par2 - 1, par3, par4 - 1);
	        int i2 = par1World.getBlockId(par2 + 1, par3, par4 - 1);
	        int j2 = par1World.getBlockId(par2 + 1, par3, par4 + 1);
	        int k2 = par1World.getBlockId(par2 - 1, par3, par4 + 1);
	        boolean flag = j1 == this.blockID || k1 == this.blockID;
	        boolean flag1 = l == this.blockID || i1 == this.blockID;
	        boolean flag2 = l1 == this.blockID || i2 == this.blockID || j2 == this.blockID || k2 == this.blockID;

	        for (int l2 = par2 - 1; l2 <= par2 + 1; ++l2)
	        {
	            for (int i3 = par4 - 1; i3 <= par4 + 1; ++i3)
	            {
	                int j3 = par1World.getBlockId(l2, par3 - 1, i3);
	                float f1 = 0.0F;

	                if (blocksList[j3] != null && blocksList[j3].canSustainPlant(par1World, l2, par3 - 1, i3, ForgeDirection.UP, this))
	                {
	                    f1 = 1.0F;

	                    if (blocksList[j3].isFertile(par1World, l2, par3 - 1, i3))
	                    {
	                        f1 = 3.0F;
	                    }
	                }

	                if (l2 != par2 || i3 != par4)
	                {
	                    f1 /= 4.0F;
	                }

	                f += f1;
	            }
	        }

	        if (flag2 || flag && flag1)
	        {
	            f /= 2.0F;
	        }

	        return f;
	    }

	    @SideOnly(Side.CLIENT)

	    /**
	     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
	     */
	    public Icon getBlockTextureFromSideAndMetadata(int par1, int par2)
	    {
	        if (par2 < 0 || par2 > 7)
	        {
	            par2 = 7;
	        }

	        return this.field_94363_a[par2];
	    }

	    /**
	     * The type of render function that is called for this block
	     */
	    public int getRenderType()
	    {
	        return 6;
	    }
	    
	   
	    @Override
	    public int idDropped(int i, Random random, int j)
	    {

	        if (j == 7)
	        {
	            return PamHCTea.tealeafItem.itemID;
	        }
	        if (i == 7)
	        {
	        	return PamHCTea.tealeafItem.itemID;
	        }

	        
			return j;
	    }
	    
	    /**
	     * Returns the quantity of items to drop on block destruction.
	     */
	    public int quantityDropped(Random par1Random)
	    {
	        return par1Random.nextInt(1) + 3;
	    }


	    @Override
	    @SideOnly(Side.CLIENT)
	    public void registerIcons(IconRegister par1IconRegister)
	    {
	        this.field_94363_a = new Icon[8];

	        for (int i = 0; i < this.field_94363_a.length; ++i)
	        {
	            this.field_94363_a[i] = par1IconRegister.registerIcon("PamHarvestCraft:"+veg+"crop_" + i);
	        }
	    }
}
