package mods.PamHarvestCraft.crops.sweetpotato;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCSweetpotato", name = "Pam's HarvestCraft Sweetpotato", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCSweetpotato
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.sweetpotato.ClientProxyPamHCSweetpotato", serverSide = "mods.PamHarvestCraft.crops.sweetpotato.CommonProxyPamHCSweetpotato")
	public static CommonProxyPamHCSweetpotato proxy;
	
	public static int sweetpotatocropID = 3832;
	public static int sweetpotatostorageID = 3833;
	public static int sweetpotatoID = 15787;
	public static int sweetpotatoseedID = 15788;
	public static int sweetpotatoseedpacketID = 15789;
	public static int sweetpotatoseedboxID = 15790;
	public static int bakedsweetpotatoID = 15791;
	
	public static boolean seeddropfromgrass = true;
	public static int sweetpotatocropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamSweetpotatoBonemealEvent());
		try {
			cfg.load();
			sweetpotatocropID = cfg.get(cfg.CATEGORY_BLOCK, "sweetpotatocropID", 3832).getInt();
			sweetpotatostorageID = cfg.get(cfg.CATEGORY_BLOCK, "sweetpotatostorageID", 3833).getInt();
			sweetpotatoID = cfg.get(cfg.CATEGORY_ITEM, "sweetpotatoID", 15787).getInt();
			sweetpotatoseedID = cfg.get(cfg.CATEGORY_ITEM, "sweetpotatoseedID", 15788).getInt();
			sweetpotatoseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "sweetpotatoseedpacketID", 15789).getInt();
			sweetpotatoseedboxID = cfg.get(cfg.CATEGORY_ITEM, "sweetpotatoseedboxID", 15790).getInt();
			bakedsweetpotatoID = cfg.get(cfg.CATEGORY_ITEM, "bakedsweetpotatoID", 15791).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			sweetpotatocropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "sweetpotatocropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCSweetpotato has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamsweetpotatoCrop;
	public static Block pamsweetpotatoStorage;
	public static Item sweetpotatoItem;
	public static Item sweetpotatoseedItem;
	public static Item sweetpotatoseedpacketItem;
	public static Item sweetpotatoseedboxItem;
	public static Item bakedsweetpotatoItem;
	
	public static ItemStack sweetpotatoStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamsweetpotatoCrop = new BlockPamSweetpotatoCrop(sweetpotatocropID, "sweetpotato", 0);
		pamsweetpotatoStorage = new BlockPamStorage(sweetpotatostorageID, 0).setUnlocalizedName("PamHarvestCraft:sweetpotatoStorage");
		
		sweetpotatoItem = new ItemPamSeedFood(sweetpotatoID, sweetpotatocropfoodrestore, 1.2F, PamHCSweetpotato.pamsweetpotatoCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:sweetpotatoItem");
		sweetpotatoseedItem = new ItemPamSeed(sweetpotatoseedID, PamHCSweetpotato.pamsweetpotatoCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:sweetpotatoseedItem");
		sweetpotatoseedpacketItem = new ItemPam(sweetpotatoseedpacketID).setUnlocalizedName("PamHarvestCraft:sweetpotatoseedpacketItem");
		sweetpotatoseedboxItem = new ItemPam(sweetpotatoseedboxID).setUnlocalizedName("PamHarvestCraft:sweetpotatoseedboxItem");
		bakedsweetpotatoItem = new ItemPamFood(bakedsweetpotatoID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:bakedsweetpotatoItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(sweetpotatoseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamsweetpotatoCrop);
		ModLoader.registerBlock(pamsweetpotatoStorage);
		
		sweetpotatoStorage = new ItemStack(pamsweetpotatoStorage, 1, 0);

		LanguageRegistry.addName(sweetpotatoItem, "Sweet Potato");
		LanguageRegistry.addName(sweetpotatoseedItem, "Sweet Potato Seed");
		LanguageRegistry.addName(sweetpotatoseedpacketItem, "Sweet Potato Seed Packet");
		LanguageRegistry.addName(sweetpotatoseedboxItem, "Sweet Potato Seed Box");
		LanguageRegistry.addName(bakedsweetpotatoItem, "Baked Sweetpotatos");
		
		LanguageRegistry.addName(sweetpotatoStorage, "Sweet Potato Crate");
	    
		OreDictionary.registerOre("cropSweetpotato", PamHCSweetpotato.sweetpotatoItem);
		OreDictionary.registerOre("seedSweetpotato", PamHCSweetpotato.sweetpotatoseedItem);
		OreDictionary.registerOre("foodBakedsweetpotato", PamHCSweetpotato.bakedsweetpotatoItem);
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSweetpotato.sweetpotatoseedItem, sweetpotatoItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSweetpotato.sweetpotatoItem, 2), "cropSweetpotato", "cropSweetpotato"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSweetpotato.pamsweetpotatoStorage, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem, sweetpotatoItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSweetpotato.sweetpotatoItem, 9), pamsweetpotatoStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSweetpotato.sweetpotatoseedpacketItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem, sweetpotatoseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSweetpotato.sweetpotatoseedItem, 8), sweetpotatoseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSweetpotato.sweetpotatoseedboxItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem, sweetpotatoseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSweetpotato.sweetpotatoseedpacketItem, 8), sweetpotatoseedboxItem));
		
		GameRegistry.addSmelting(PamHCSweetpotato.sweetpotatoItem.itemID, new ItemStack(PamHCSweetpotato.bakedsweetpotatoItem, 1, 0), 0.1F);
	 
	 }

}