package mods.PamHarvestCraft.crops.rotten;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCRotten", name = "Pam's HarvestCraft Rotten", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCRotten
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.rotten.ClientProxyPamHCRotten", serverSide = "mods.PamHarvestCraft.crops.rotten.CommonProxyPamHCRotten")
	public static CommonProxyPamHCRotten proxy;
	
	public static int rottencropID = 3836;
	public static int rottenseedID = 15751;
	public static int rottenseedpacketID = 15752;
	public static int rottenseedboxID = 15753;

	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamRottenBonemealEvent());
		try {
			cfg.load();
			rottencropID = cfg.get(cfg.CATEGORY_BLOCK, "rottencropID", 3836).getInt();
			rottenseedID = cfg.get(cfg.CATEGORY_ITEM, "rottenseedID", 15751).getInt();
			rottenseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "rottenseedpacketID", 15752).getInt();
			rottenseedboxID = cfg.get(cfg.CATEGORY_ITEM, "rottenseedboxID", 15753).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCRotten has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamrottenCrop;
	public static Item rottenseedItem;
	public static Item rottenseedpacketItem;
	public static Item rottenseedboxItem;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamrottenCrop = new BlockPamRottenCrop(rottencropID, "rotten", 0);
		rottenseedItem = new ItemPamSeed(rottenseedID, PamHCRotten.pamrottenCrop.blockID, Block.slowSand.blockID).setUnlocalizedName("PamHarvestCraft:rottenseedItem");
		rottenseedpacketItem = new ItemPam(rottenseedpacketID).setUnlocalizedName("PamHarvestCraft:rottenseedpacketItem");
		rottenseedboxItem = new ItemPam(rottenseedboxID).setUnlocalizedName("PamHarvestCraft:rottenseedboxItem");

		ModLoader.registerBlock(pamrottenCrop);

		LanguageRegistry.addName(rottenseedItem, "Rotten Seed");
		LanguageRegistry.addName(rottenseedpacketItem, "Rotten Seed Packet");
		LanguageRegistry.addName(rottenseedboxItem, "Rotten Seed Box");

		OreDictionary.registerOre("seedRotten", PamHCRotten.rottenseedItem);

		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRotten.rottenseedItem, Item.rottenFlesh));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRotten.rottenseedpacketItem, rottenseedItem, rottenseedItem, rottenseedItem, rottenseedItem, rottenseedItem, rottenseedItem, rottenseedItem, rottenseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRotten.rottenseedItem, 8), rottenseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRotten.rottenseedboxItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem, rottenseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRotten.rottenseedpacketItem, 8), rottenseedboxItem));
		
	 
	 }

}