package mods.PamHarvestCraft.crops.radish;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCRadish", name = "Pam's HarvestCraft Radish", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCRadish
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.radish.ClientProxyPamHCRadish", serverSide = "mods.PamHarvestCraft.crops.radish.CommonProxyPamHCRadish")
	public static CommonProxyPamHCRadish proxy;
	
	public static int radishcropID = 3830;
	public static int radishstorageID = 3831;
	public static int radishID = 15782;
	public static int radishseedID = 15783;
	public static int radishseedpacketID = 15784;
	public static int radishseedboxID = 15785;
	public static int grilledradishID = 15786;
	
	public static boolean seeddropfromgrass = true;
	public static int radishcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamRadishBonemealEvent());
		try {
			cfg.load();
			radishcropID = cfg.get(cfg.CATEGORY_BLOCK, "radishcropID", 3830).getInt();
			radishstorageID = cfg.get(cfg.CATEGORY_BLOCK, "radishstorageID", 3831).getInt();
			radishID = cfg.get(cfg.CATEGORY_ITEM, "radishID", 15782).getInt();
			radishseedID = cfg.get(cfg.CATEGORY_ITEM, "radishseedID", 15783).getInt();
			radishseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "radishseedpacketID", 15784).getInt();
			radishseedboxID = cfg.get(cfg.CATEGORY_ITEM, "radishseedboxID", 15785).getInt();
			grilledradishID = cfg.get(cfg.CATEGORY_ITEM, "grilledradishID", 15786).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			radishcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "radishcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCRadish has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamradishCrop;
	public static Block pamradishStorage;
	public static Item radishItem;
	public static Item radishseedItem;
	public static Item radishseedpacketItem;
	public static Item radishseedboxItem;
	public static Item grilledradishItem;
	
	public static ItemStack radishStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamradishCrop = new BlockPamRadishCrop(radishcropID, "radish", 0);
		pamradishStorage = new BlockPamStorage(radishstorageID, 0).setUnlocalizedName("PamHarvestCraft:radishStorage");
		
		radishItem = new ItemPamSeedFood(radishID, radishcropfoodrestore, 1.2F, PamHCRadish.pamradishCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:radishItem");
		radishseedItem = new ItemPamSeed(radishseedID, PamHCRadish.pamradishCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:radishseedItem");
		radishseedpacketItem = new ItemPam(radishseedpacketID).setUnlocalizedName("PamHarvestCraft:radishseedpacketItem");
		radishseedboxItem = new ItemPam(radishseedboxID).setUnlocalizedName("PamHarvestCraft:radishseedboxItem");
		grilledradishItem = new ItemPamFood(grilledradishID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:grilledradishItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(radishseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamradishCrop);
		ModLoader.registerBlock(pamradishStorage);
		
		radishStorage = new ItemStack(pamradishStorage, 1, 0);

		LanguageRegistry.addName(radishItem, "Radish");
		LanguageRegistry.addName(radishseedItem, "Radish Seed");
		LanguageRegistry.addName(radishseedpacketItem, "Radish Seed Packet");
		LanguageRegistry.addName(radishseedboxItem, "Radish Seed Box");
		LanguageRegistry.addName(grilledradishItem, "Grilled Radishs");
		
		LanguageRegistry.addName(radishStorage, "Radish Crate");
	    
		OreDictionary.registerOre("cropRadish", PamHCRadish.radishItem);
		OreDictionary.registerOre("seedRadish", PamHCRadish.radishseedItem);
		OreDictionary.registerOre("foodGrilledradish", PamHCRadish.grilledradishItem);
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRadish.radishseedItem, radishItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRadish.radishItem, 2), "cropRadish", "cropRadish"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRadish.pamradishStorage, radishItem, radishItem, radishItem, radishItem, radishItem, radishItem, radishItem, radishItem, radishItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRadish.radishItem, 9), pamradishStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRadish.radishseedpacketItem, radishseedItem, radishseedItem, radishseedItem, radishseedItem, radishseedItem, radishseedItem, radishseedItem, radishseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRadish.radishseedItem, 8), radishseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCRadish.radishseedboxItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem, radishseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCRadish.radishseedpacketItem, 8), radishseedboxItem));
		
		GameRegistry.addSmelting(PamHCRadish.radishItem.itemID, new ItemStack(PamHCRadish.grilledradishItem, 1, 0), 0.1F);
	 
	 }

}