package mods.PamHarvestCraft.crops.pineapple;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPineapple", name = "Pam's HarvestCraft Pineapple", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPineapple
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.pineapple.ClientProxyPamHCPineapple", serverSide = "mods.PamHarvestCraft.crops.pineapple.CommonProxyPamHCPineapple")
	public static CommonProxyPamHCPineapple proxy;
	
	public static int pineapplecropID = 3820;
	public static int pineapplestorageID = 3821;
	public static int pineappleID = 15762;
	public static int pineappleseedID = 15763;
	public static int pineappleseedpacketID = 15764;
	public static int pineappleseedboxID = 15765;

	
	public static boolean seeddropfromgrass = true;
	public static int pineapplecropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamPineappleBonemealEvent());
		try {
			cfg.load();
			pineapplecropID = cfg.get(cfg.CATEGORY_BLOCK, "pineapplecropID", 3820).getInt();
			pineapplestorageID = cfg.get(cfg.CATEGORY_BLOCK, "pineapplestorageID", 3821).getInt();
			pineappleID = cfg.get(cfg.CATEGORY_ITEM, "pineappleID", 15762).getInt();
			pineappleseedID = cfg.get(cfg.CATEGORY_ITEM, "pineappleseedID", 15763).getInt();
			pineappleseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "pineappleseedpacketID", 15764).getInt();
			pineappleseedboxID = cfg.get(cfg.CATEGORY_ITEM, "pineappleseedboxID", 15765).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			pineapplecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "pineapplecropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPineapple has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pampineappleCrop;
	public static Block pampineappleStorage;
	public static Item pineappleItem;
	public static Item pineappleseedItem;
	public static Item pineappleseedpacketItem;
	public static Item pineappleseedboxItem;
	
	public static ItemStack pineappleStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pampineappleCrop = new BlockPamPineappleCrop(pineapplecropID, "pineapple", 0);
		pampineappleStorage = new BlockPamStorage(pineapplestorageID, 0).setUnlocalizedName("PamHarvestCraft:pineappleStorage");
		
		pineappleItem = new ItemPamFood(pineappleID, pineapplecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:pineappleItem");
		pineappleseedItem = new ItemPamSeed(pineappleseedID, PamHCPineapple.pampineappleCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:pineappleseedItem");
		pineappleseedpacketItem = new ItemPam(pineappleseedpacketID).setUnlocalizedName("PamHarvestCraft:pineappleseedpacketItem");
		pineappleseedboxItem = new ItemPam(pineappleseedboxID).setUnlocalizedName("PamHarvestCraft:pineappleseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(pineappleseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pampineappleCrop);
		ModLoader.registerBlock(pampineappleStorage);
		
		pineappleStorage = new ItemStack(pampineappleStorage, 1, 0);

		LanguageRegistry.addName(pineappleItem, "Pineapple");
		LanguageRegistry.addName(pineappleseedItem, "Pineapple Seed");
		LanguageRegistry.addName(pineappleseedpacketItem, "Pineapple Seed Packet");
		LanguageRegistry.addName(pineappleseedboxItem, "Pineapple Seed Box");
		
		LanguageRegistry.addName(pineappleStorage, "Pineapple Crate");

	    
		OreDictionary.registerOre("cropPineapple", PamHCPineapple.pineappleItem);
		OreDictionary.registerOre("seedPineapple", PamHCPineapple.pineappleseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPineapple.pineappleseedItem, pineappleItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPineapple.pineappleItem, 2), "cropPineapple", "cropPineapple"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPineapple.pampineappleStorage, pineappleItem, pineappleItem, pineappleItem, pineappleItem, pineappleItem, pineappleItem, pineappleItem, pineappleItem, pineappleItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPineapple.pineappleItem, 9), pampineappleStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPineapple.pineappleseedpacketItem, pineappleseedItem, pineappleseedItem, pineappleseedItem, pineappleseedItem, pineappleseedItem, pineappleseedItem, pineappleseedItem, pineappleseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPineapple.pineappleseedItem, 8), pineappleseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPineapple.pineappleseedboxItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem, pineappleseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPineapple.pineappleseedpacketItem, 8), pineappleseedboxItem));
		

	 
	 }

}