package mods.PamHarvestCraft.crops.peas;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPeas", name = "Pam's HarvestCraft Peas", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPeas
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.peas.ClientProxyPamHCPeas", serverSide = "mods.PamHarvestCraft.crops.peas.CommonProxyPamHCPeas")
	public static CommonProxyPamHCPeas proxy;
	
	public static int peascropID = 3804;
	public static int peasstorageID = 3805;
	public static int peasID = 15730;
	public static int peasseedID = 15731;
	public static int peasseedpacketID = 15732;
	public static int peasseedboxID = 15733;

	
	public static boolean seeddropfromgrass = true;
	public static int peascropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamPeasBonemealEvent());
		try {
			cfg.load();
			peascropID = cfg.get(cfg.CATEGORY_BLOCK, "peascropID", 3804).getInt();
			peasstorageID = cfg.get(cfg.CATEGORY_BLOCK, "peasstorageID", 3805).getInt();
			peasID = cfg.get(cfg.CATEGORY_ITEM, "peasID", 15730).getInt();
			peasseedID = cfg.get(cfg.CATEGORY_ITEM, "peasseedID", 15731).getInt();
			peasseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "peasseedpacketID", 15732).getInt();
			peasseedboxID = cfg.get(cfg.CATEGORY_ITEM, "peasseedboxID", 15733).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			peascropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "peascropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPeas has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pampeasCrop;
	public static Block pampeasStorage;
	public static Item peasItem;
	public static Item peasseedItem;
	public static Item peasseedpacketItem;
	public static Item peasseedboxItem;
	
	public static ItemStack peasStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pampeasCrop = new BlockPamPeasCrop(peascropID, "peas", 0);
		pampeasStorage = new BlockPamStorage(peasstorageID, 0).setUnlocalizedName("PamHarvestCraft:peasStorage");
		
		peasItem = new ItemPamSeedFood(peasID, peascropfoodrestore, 1.2F, PamHCPeas.pampeasCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:peasItem");
		peasseedItem = new ItemPamSeed(peasseedID, PamHCPeas.pampeasCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:peasseedItem");
		peasseedpacketItem = new ItemPam(peasseedpacketID).setUnlocalizedName("PamHarvestCraft:peasseedpacketItem");
		peasseedboxItem = new ItemPam(peasseedboxID).setUnlocalizedName("PamHarvestCraft:peasseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(peasseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pampeasCrop);
		ModLoader.registerBlock(pampeasStorage);
		
		peasStorage = new ItemStack(pampeasStorage, 1, 0);

		LanguageRegistry.addName(peasItem, "Peas");
		LanguageRegistry.addName(peasseedItem, "Peas Seed");
		LanguageRegistry.addName(peasseedpacketItem, "Peas Seed Packet");
		LanguageRegistry.addName(peasseedboxItem, "Peas Seed Box");
		
		LanguageRegistry.addName(peasStorage, "Peas Crate");

	    
		OreDictionary.registerOre("cropPeas", PamHCPeas.peasItem);
		OreDictionary.registerOre("seedPeas", PamHCPeas.peasseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeas.peasseedItem, peasItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeas.peasItem, 2), "cropPeas", "cropPeas"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeas.pampeasStorage, peasItem, peasItem, peasItem, peasItem, peasItem, peasItem, peasItem, peasItem, peasItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeas.peasItem, 9), pampeasStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeas.peasseedpacketItem, peasseedItem, peasseedItem, peasseedItem, peasseedItem, peasseedItem, peasseedItem, peasseedItem, peasseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeas.peasseedItem, 8), peasseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeas.peasseedboxItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem, peasseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeas.peasseedpacketItem, 8), peasseedboxItem));
		

	 
	 }

}