package mods.PamHarvestCraft.crops.peanut;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCPeanut", name = "Pam's HarvestCraft Peanut", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCPeanut
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.peanut.ClientProxyPamHCPeanut", serverSide = "mods.PamHarvestCraft.crops.peanut.CommonProxyPamHCPeanut")
	public static CommonProxyPamHCPeanut proxy;
	
	public static int peanutcropID = 4074;
	public static int peanutstorageID = 4075;
	public static int peanutID = 13401;
	public static int peanutseedID = 13402;
	public static int peanutseedpacketID = 13403;
	public static int peanutseedboxID = 13404;
	public static int roastedpeanutID = 13407;
	
	public static boolean seeddropfromgrass = true;
	public static int peanutcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamPeanutBonemealEvent());
		try {
			cfg.load();
			peanutcropID = cfg.get(cfg.CATEGORY_BLOCK, "peanutcropID", 4074).getInt();
			peanutstorageID = cfg.get(cfg.CATEGORY_BLOCK, "peanutstorageID", 4075).getInt();
			peanutID = cfg.get(cfg.CATEGORY_ITEM, "peanutID", 13401).getInt();
			peanutseedID = cfg.get(cfg.CATEGORY_ITEM, "peanutseedID", 13402).getInt();
			peanutseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "peanutseedpacketID", 13403).getInt();
			peanutseedboxID = cfg.get(cfg.CATEGORY_ITEM, "peanutseedboxID", 13404).getInt();
			roastedpeanutID = cfg.get(cfg.CATEGORY_ITEM, "roastedpeanutID", 13407).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			peanutcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "peanutcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCPeanut has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pampeanutCrop;
	public static Block pampeanutStorage;
	public static Item peanutItem;
	public static Item peanutseedItem;
	public static Item peanutseedpacketItem;
	public static Item peanutseedboxItem;
	public static Item roastedpeanutItem;
	
	public static ItemStack peanutStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pampeanutCrop = new BlockPamPeanutCrop(peanutcropID, "peanut", 0);
		pampeanutStorage = new BlockPamStorage(peanutstorageID, 0).setUnlocalizedName("PamHarvestCraft:peanutStorage");
		
		peanutItem = new ItemPamSeedFood(peanutID, peanutcropfoodrestore, 1.2F, PamHCPeanut.pampeanutCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:peanutItem");
		peanutseedItem = new ItemPamSeed(peanutseedID, PamHCPeanut.pampeanutCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:peanutseedItem");
		peanutseedpacketItem = new ItemPam(peanutseedpacketID).setUnlocalizedName("PamHarvestCraft:peanutseedpacketItem");
		peanutseedboxItem = new ItemPam(peanutseedboxID).setUnlocalizedName("PamHarvestCraft:peanutseedboxItem");
		roastedpeanutItem = new ItemPamFood(roastedpeanutID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:roastedpeanutItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(peanutseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pampeanutCrop);
		ModLoader.registerBlock(pampeanutStorage);
		
		peanutStorage = new ItemStack(pampeanutStorage, 1, 0);

		LanguageRegistry.addName(peanutItem, "Peanut");
		LanguageRegistry.addName(peanutseedItem, "Peanut Seed");
		LanguageRegistry.addName(peanutseedpacketItem, "Peanut Seed Packet");
		LanguageRegistry.addName(peanutseedboxItem, "Peanut Seed Box");
		LanguageRegistry.addName(roastedpeanutItem, "Roasted Peanuts");
		
		LanguageRegistry.addName(peanutStorage, "Peanut Crate");
	    
		OreDictionary.registerOre("cropPeanut", PamHCPeanut.peanutItem);
		OreDictionary.registerOre("seedPeanut", PamHCPeanut.peanutseedItem);
		OreDictionary.registerOre("foodGrilledpeanut", PamHCPeanut.roastedpeanutItem);
		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeanut.peanutseedItem, peanutItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeanut.peanutItem, 2), "cropPeanut", "cropPeanut"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeanut.pampeanutStorage, peanutItem, peanutItem, peanutItem, peanutItem, peanutItem, peanutItem, peanutItem, peanutItem, peanutItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeanut.peanutItem, 9), pampeanutStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeanut.peanutseedpacketItem, peanutseedItem, peanutseedItem, peanutseedItem, peanutseedItem, peanutseedItem, peanutseedItem, peanutseedItem, peanutseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeanut.peanutseedItem, 8), peanutseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCPeanut.peanutseedboxItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem, peanutseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCPeanut.peanutseedpacketItem, 8), peanutseedboxItem));
		
		GameRegistry.addSmelting(PamHCPeanut.peanutItem.itemID, new ItemStack(PamHCPeanut.roastedpeanutItem, 1, 0), 0.1F);
	 
	 }

}