package mods.PamHarvestCraft.crops.onion;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCOnion", name = "Pam's HarvestCraft Onion", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCOnion
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.onion.ClientProxyPamHCOnion", serverSide = "mods.PamHarvestCraft.crops.onion.CommonProxyPamHCOnion")
	public static CommonProxyPamHCOnion proxy;
	
	public static int onioncropID = 4024;
	public static int onionstorageID = 4025;
	public static int onionID = 15251;
	public static int onionseedID = 15252;
	public static int onionseedpacketID = 15253;
	public static int onionseedboxID = 15254;

	
	public static boolean seeddropfromgrass = true;
	public static int onioncropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamOnionBonemealEvent());
		try {
			cfg.load();
			onioncropID = cfg.get(cfg.CATEGORY_BLOCK, "onioncropID", 4024).getInt();
			onionstorageID = cfg.get(cfg.CATEGORY_BLOCK, "onionstorageID", 4025).getInt();
			onionID = cfg.get(cfg.CATEGORY_ITEM, "onionID", 15251).getInt();
			onionseedID = cfg.get(cfg.CATEGORY_ITEM, "onionseedID", 15252).getInt();
			onionseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "onionseedpacketID", 15253).getInt();
			onionseedboxID = cfg.get(cfg.CATEGORY_ITEM, "onionseedboxID", 15254).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			onioncropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "onioncropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCOnion has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamonionCrop;
	public static Block pamonionStorage;
	public static Item onionItem;
	public static Item onionseedItem;
	public static Item onionseedpacketItem;
	public static Item onionseedboxItem;
	
	public static ItemStack onionStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamonionCrop = new BlockPamOnionCrop(onioncropID, "onion", 0);
		pamonionStorage = new BlockPamStorage(onionstorageID, 0).setUnlocalizedName("PamHarvestCraft:onionStorage");
		
		onionItem = new ItemPamSeedFood(onionID, onioncropfoodrestore, 1.2F, PamHCOnion.pamonionCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:onionItem");
		onionseedItem = new ItemPamSeed(onionseedID, PamHCOnion.pamonionCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:onionseedItem");
		onionseedpacketItem = new ItemPam(onionseedpacketID).setUnlocalizedName("PamHarvestCraft:onionseedpacketItem");
		onionseedboxItem = new ItemPam(onionseedboxID).setUnlocalizedName("PamHarvestCraft:onionseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(onionseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamonionCrop);
		ModLoader.registerBlock(pamonionStorage);
		
		onionStorage = new ItemStack(pamonionStorage, 1, 0);

		LanguageRegistry.addName(onionItem, "Onion");
		LanguageRegistry.addName(onionseedItem, "Onion Seed");
		LanguageRegistry.addName(onionseedpacketItem, "Onion Seed Packet");
		LanguageRegistry.addName(onionseedboxItem, "Onion Seed Box");
		
		LanguageRegistry.addName(onionStorage, "Onion Crate");

	    
		OreDictionary.registerOre("cropOnion", PamHCOnion.onionItem);
		OreDictionary.registerOre("seedOnion", PamHCOnion.onionseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOnion.onionseedItem, onionItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOnion.onionItem, 2), "cropOnion", "cropOnion"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOnion.pamonionStorage, onionItem, onionItem, onionItem, onionItem, onionItem, onionItem, onionItem, onionItem, onionItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOnion.onionItem, 9), pamonionStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOnion.onionseedpacketItem, onionseedItem, onionseedItem, onionseedItem, onionseedItem, onionseedItem, onionseedItem, onionseedItem, onionseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOnion.onionseedItem, 8), onionseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCOnion.onionseedboxItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem, onionseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCOnion.onionseedpacketItem, 8), onionseedboxItem));
		

	 
	 }

}