package mods.PamHarvestCraft.crops.mustard;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCMustard", name = "Pam's HarvestCraft Mustard", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCMustard
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.mustard.ClientProxyPamHCMustard", serverSide = "mods.PamHarvestCraft.crops.mustard.CommonProxyPamHCMustard")
	public static CommonProxyPamHCMustard proxy;
	
	public static int mustardcropID = 3806;
	public static int mustardstorageID = 3807;
	public static int mustardseedsID = 15734;
	public static int mustardseedID = 15735;
	public static int mustardseedpacketID = 15736;
	public static int mustardseedboxID = 15737;

	
	public static boolean seeddropfromgrass = true;
	public static int mustardcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamMustardBonemealEvent());
		try {
			cfg.load();
			mustardcropID = cfg.get(cfg.CATEGORY_BLOCK, "mustardcropID", 3806).getInt();
			mustardstorageID = cfg.get(cfg.CATEGORY_BLOCK, "mustardstorageID", 3807).getInt();
			mustardseedsID = cfg.get(cfg.CATEGORY_ITEM, "mustardseedsID", 15734).getInt();
			mustardseedID = cfg.get(cfg.CATEGORY_ITEM, "mustardseedID", 15735).getInt();
			mustardseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "mustardseedpacketID", 15736).getInt();
			mustardseedboxID = cfg.get(cfg.CATEGORY_ITEM, "mustardseedboxID", 15737).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			mustardcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "mustardcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCMustard has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pammustardCrop;
	public static Block pammustardStorage;
	public static Item mustardseedsItem;
	public static Item mustardseedItem;
	public static Item mustardseedpacketItem;
	public static Item mustardseedboxItem;
	
	public static ItemStack mustardStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pammustardCrop = new BlockPamMustardCrop(mustardcropID, "mustard", 0);
		pammustardStorage = new BlockPamStorage(mustardstorageID, 0).setUnlocalizedName("PamHarvestCraft:mustardStorage");
		
		mustardseedsItem = new ItemPamSeedFood(mustardseedsID, mustardcropfoodrestore, 1.2F, PamHCMustard.pammustardCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:mustardseedsItem");
		mustardseedItem = new ItemPamSeed(mustardseedID, PamHCMustard.pammustardCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:mustardseedItem");
		mustardseedpacketItem = new ItemPam(mustardseedpacketID).setUnlocalizedName("PamHarvestCraft:mustardseedpacketItem");
		mustardseedboxItem = new ItemPam(mustardseedboxID).setUnlocalizedName("PamHarvestCraft:mustardseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(mustardseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pammustardCrop);
		ModLoader.registerBlock(pammustardStorage);
		
		mustardStorage = new ItemStack(pammustardStorage, 1, 0);

		LanguageRegistry.addName(mustardseedsItem, "Mustard");
		LanguageRegistry.addName(mustardseedItem, "Mustard Seed");
		LanguageRegistry.addName(mustardseedpacketItem, "Mustard Seed Packet");
		LanguageRegistry.addName(mustardseedboxItem, "Mustard Seed Box");
		
		LanguageRegistry.addName(mustardStorage, "Mustard Crate");

	    
		OreDictionary.registerOre("cropMustard", PamHCMustard.mustardseedsItem);
		OreDictionary.registerOre("seedMustard", PamHCMustard.mustardseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCMustard.mustardseedItem, mustardseedsItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMustard.mustardseedsItem, 2), "cropMustard", "cropMustard"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCMustard.pammustardStorage, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem, mustardseedsItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMustard.mustardseedsItem, 9), pammustardStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCMustard.mustardseedpacketItem, mustardseedItem, mustardseedItem, mustardseedItem, mustardseedItem, mustardseedItem, mustardseedItem, mustardseedItem, mustardseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMustard.mustardseedItem, 8), mustardseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCMustard.mustardseedboxItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem, mustardseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCMustard.mustardseedpacketItem, 8), mustardseedboxItem));
		

	 
	 }

}