package mods.PamHarvestCraft.crops.lettuce;

import java.util.logging.Level;

import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCLettuce", name = "Pam's HarvestCraft Lettuce", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCLettuce
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.lettuce.ClientProxyPamHCLettuce", serverSide = "mods.PamHarvestCraft.crops.lettuce.CommonProxyPamHCLettuce")
	public static CommonProxyPamHCLettuce proxy;
	
	public static int lettucecropID = 4022;
	public static int lettucestorageID = 4023;
	public static int lettuceID = 15226;
	public static int lettuceseedID = 15227;
	public static int lettuceseedpacketID = 15228;
	public static int lettuceseedboxID = 15229;

	
	public static boolean seeddropfromgrass = true;
	public static int lettucecropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamLettuceBonemealEvent());
		try {
			cfg.load();
			lettucecropID = cfg.get(cfg.CATEGORY_BLOCK, "lettucecropID", 4022).getInt();
			lettucestorageID = cfg.get(cfg.CATEGORY_BLOCK, "lettucestorageID", 4023).getInt();
			lettuceID = cfg.get(cfg.CATEGORY_ITEM, "lettuceID", 15226).getInt();
			lettuceseedID = cfg.get(cfg.CATEGORY_ITEM, "lettuceseedID", 15227).getInt();
			lettuceseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "lettuceseedpacketID", 15228).getInt();
			lettuceseedboxID = cfg.get(cfg.CATEGORY_ITEM, "lettuceseedboxID", 15229).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			lettucecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "lettucecropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCLettuce has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamlettuceCrop;
	public static Block pamlettuceStorage;
	public static Item lettuceItem;
	public static Item lettuceseedItem;
	public static Item lettuceseedpacketItem;
	public static Item lettuceseedboxItem;
	
	public static ItemStack lettuceStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		
		
		proxy.registerRenderThings();
		
		pamlettuceCrop = new BlockPamLettuceCrop(lettucecropID, "lettuce", 0);
		pamlettuceStorage = new BlockPamStorage(lettucestorageID, 0).setUnlocalizedName("PamHarvestCraft:lettuceStorage");
		
		lettuceItem = new ItemPamFood(lettuceID, lettucecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:lettuceItem");
		lettuceseedItem = new ItemPamSeed(lettuceseedID, PamHCLettuce.pamlettuceCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:lettuceseedItem");
		lettuceseedpacketItem = new ItemPam(lettuceseedpacketID).setUnlocalizedName("PamHarvestCraft:lettuceseedpacketItem");
		lettuceseedboxItem = new ItemPam(lettuceseedboxID).setUnlocalizedName("PamHarvestCraft:lettuceseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(lettuceseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamlettuceCrop);
		ModLoader.registerBlock(pamlettuceStorage);
		
		lettuceStorage = new ItemStack(pamlettuceStorage, 1, 0);

		LanguageRegistry.addName(lettuceItem, "Lettuce");
		LanguageRegistry.addName(lettuceseedItem, "Lettuce Seed");
		LanguageRegistry.addName(lettuceseedpacketItem, "Lettuce Seed Packet");
		LanguageRegistry.addName(lettuceseedboxItem, "Lettuce Seed Box");
		
		LanguageRegistry.addName(lettuceStorage, "Lettuce Crate");

	    
		OreDictionary.registerOre("cropLettuce", PamHCLettuce.lettuceItem);
		OreDictionary.registerOre("seedLettuce", PamHCLettuce.lettuceseedItem);
		OreDictionary.registerOre("listAllseed", PamHCLettuce.lettuceseedItem);
		
		FMLInterModComms.sendMessage("Forestry", "add-farmable-crop", String.format("farmWheat@%s.%s.%s.%s", lettuceseedItem.itemID, 0, lettucecropID, 7));

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCLettuce.lettuceseedItem, lettuceItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLettuce.lettuceItem, 2), "cropLettuce", "cropLettuce"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCLettuce.pamlettuceStorage, lettuceItem, lettuceItem, lettuceItem, lettuceItem, lettuceItem, lettuceItem, lettuceItem, lettuceItem, lettuceItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLettuce.lettuceItem, 9), pamlettuceStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCLettuce.lettuceseedpacketItem, lettuceseedItem, lettuceseedItem, lettuceseedItem, lettuceseedItem, lettuceseedItem, lettuceseedItem, lettuceseedItem, lettuceseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLettuce.lettuceseedItem, 8), lettuceseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCLettuce.lettuceseedboxItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem, lettuceseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCLettuce.lettuceseedpacketItem, 8), lettuceseedboxItem));
		
		if(Loader.isModLoaded("Thaumcraft") == true)
        {
                ThaumcraftApi.registerObjectTag(lettuceseedItem.itemID, 0, (new ObjectTags()).add(EnumTag.PLANT, 1).add(EnumTag.EXCHANGE, 1));
                ThaumcraftApi.registerObjectTag(lettuceItem.itemID, 0, (new ObjectTags()).add(EnumTag.CROP, 2).add(EnumTag.LIFE, 2));
                FMLInterModComms.sendMessage("Thaumcraft", "harvestStandardCrop", new ItemStack(PamHCLettuce.lettucecropID,1,7));
        }
	 
	 }

}