package mods.PamHarvestCraft.crops.ginger;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCGinger", name = "Pam's HarvestCraft Ginger", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCGinger
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.ginger.ClientProxyPamHCGinger", serverSide = "mods.PamHarvestCraft.crops.ginger.CommonProxyPamHCGinger")
	public static CommonProxyPamHCGinger proxy;
	
	public static int gingercropID = 3824;
	public static int gingerstorageID = 3825;
	public static int gingerID = 15770;
	public static int gingerseedID = 15771;
	public static int gingerseedpacketID = 15772;
	public static int gingerseedboxID = 15773;

	
	public static boolean seeddropfromgrass = true;
	public static int gingercropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamGingerBonemealEvent());
		try {
			cfg.load();
			gingercropID = cfg.get(cfg.CATEGORY_BLOCK, "gingercropID", 3824).getInt();
			gingerstorageID = cfg.get(cfg.CATEGORY_BLOCK, "gingerstorageID", 3825).getInt();
			gingerID = cfg.get(cfg.CATEGORY_ITEM, "gingerID", 15770).getInt();
			gingerseedID = cfg.get(cfg.CATEGORY_ITEM, "gingerseedID", 15771).getInt();
			gingerseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "gingerseedpacketID", 15772).getInt();
			gingerseedboxID = cfg.get(cfg.CATEGORY_ITEM, "gingerseedboxID", 15773).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			gingercropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "gingercropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCGinger has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamgingerCrop;
	public static Block pamgingerStorage;
	public static Item gingerItem;
	public static Item gingerseedItem;
	public static Item gingerseedpacketItem;
	public static Item gingerseedboxItem;
	
	public static ItemStack gingerStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamgingerCrop = new BlockPamGingerCrop(gingercropID, "ginger", 0);
		pamgingerStorage = new BlockPamStorage(gingerstorageID, 0).setUnlocalizedName("PamHarvestCraft:gingerStorage");
		
		gingerItem = new ItemPamSeedFood(gingerID, gingercropfoodrestore, 1.2F, PamHCGinger.pamgingerCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:gingerItem");
		gingerseedItem = new ItemPamSeed(gingerseedID, PamHCGinger.pamgingerCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:gingerseedItem");
		gingerseedpacketItem = new ItemPam(gingerseedpacketID).setUnlocalizedName("PamHarvestCraft:gingerseedpacketItem");
		gingerseedboxItem = new ItemPam(gingerseedboxID).setUnlocalizedName("PamHarvestCraft:gingerseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(gingerseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamgingerCrop);
		ModLoader.registerBlock(pamgingerStorage);
		
		gingerStorage = new ItemStack(pamgingerStorage, 1, 0);

		LanguageRegistry.addName(gingerItem, "Ginger");
		LanguageRegistry.addName(gingerseedItem, "Ginger Seed");
		LanguageRegistry.addName(gingerseedpacketItem, "Ginger Seed Packet");
		LanguageRegistry.addName(gingerseedboxItem, "Ginger Seed Box");
		
		LanguageRegistry.addName(gingerStorage, "Ginger Crate");

	    
		OreDictionary.registerOre("cropGinger", PamHCGinger.gingerItem);
		OreDictionary.registerOre("seedGinger", PamHCGinger.gingerseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGinger.gingerseedItem, gingerItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGinger.gingerItem, 2), "cropGinger", "cropGinger"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGinger.pamgingerStorage, gingerItem, gingerItem, gingerItem, gingerItem, gingerItem, gingerItem, gingerItem, gingerItem, gingerItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGinger.gingerItem, 9), pamgingerStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGinger.gingerseedpacketItem, gingerseedItem, gingerseedItem, gingerseedItem, gingerseedItem, gingerseedItem, gingerseedItem, gingerseedItem, gingerseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGinger.gingerseedItem, 8), gingerseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGinger.gingerseedboxItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem, gingerseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGinger.gingerseedpacketItem, 8), gingerseedboxItem));
		

	 
	 }

}