package mods.PamHarvestCraft.crops.garlic;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCGarlic", name = "Pam's HarvestCraft Garlic", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCGarlic
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.garlic.ClientProxyPamHCGarlic", serverSide = "mods.PamHarvestCraft.crops.garlic.CommonProxyPamHCGarlic")
	public static CommonProxyPamHCGarlic proxy;
	
	public static int garliccropID = 3826;
	public static int garlicstorageID = 3827;
	public static int garlicID = 15774;
	public static int garlicseedID = 15775;
	public static int garlicseedpacketID = 15776;
	public static int garlicseedboxID = 15777;

	
	public static boolean seeddropfromgrass = true;
	public static int garliccropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamGarlicBonemealEvent());
		try {
			cfg.load();
			garliccropID = cfg.get(cfg.CATEGORY_BLOCK, "garliccropID", 3826).getInt();
			garlicstorageID = cfg.get(cfg.CATEGORY_BLOCK, "garlicstorageID", 3827).getInt();
			garlicID = cfg.get(cfg.CATEGORY_ITEM, "garlicID", 15774).getInt();
			garlicseedID = cfg.get(cfg.CATEGORY_ITEM, "garlicseedID", 15775).getInt();
			garlicseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "garlicseedpacketID", 15776).getInt();
			garlicseedboxID = cfg.get(cfg.CATEGORY_ITEM, "garlicseedboxID", 15777).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			garliccropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "garliccropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCGarlic has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamgarlicCrop;
	public static Block pamgarlicStorage;
	public static Item garlicItem;
	public static Item garlicseedItem;
	public static Item garlicseedpacketItem;
	public static Item garlicseedboxItem;
	
	public static ItemStack garlicStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamgarlicCrop = new BlockPamGarlicCrop(garliccropID, "garlic", 0);
		pamgarlicStorage = new BlockPamStorage(garlicstorageID, 0).setUnlocalizedName("PamHarvestCraft:garlicStorage");
		
		garlicItem = new ItemPamSeedFood(garlicID, garliccropfoodrestore, 1.2F, PamHCGarlic.pamgarlicCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:garlicItem");
		garlicseedItem = new ItemPamSeed(garlicseedID, PamHCGarlic.pamgarlicCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:garlicseedItem");
		garlicseedpacketItem = new ItemPam(garlicseedpacketID).setUnlocalizedName("PamHarvestCraft:garlicseedpacketItem");
		garlicseedboxItem = new ItemPam(garlicseedboxID).setUnlocalizedName("PamHarvestCraft:garlicseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(garlicseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamgarlicCrop);
		ModLoader.registerBlock(pamgarlicStorage);
		
		garlicStorage = new ItemStack(pamgarlicStorage, 1, 0);

		LanguageRegistry.addName(garlicItem, "Garlic");
		LanguageRegistry.addName(garlicseedItem, "Garlic Seed");
		LanguageRegistry.addName(garlicseedpacketItem, "Garlic Seed Packet");
		LanguageRegistry.addName(garlicseedboxItem, "Garlic Seed Box");
		
		LanguageRegistry.addName(garlicStorage, "Garlic Crate");

	    
		OreDictionary.registerOre("cropGarlic", PamHCGarlic.garlicItem);
		OreDictionary.registerOre("seedGarlic", PamHCGarlic.garlicseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGarlic.garlicseedItem, garlicItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGarlic.garlicItem, 2), "cropGarlic", "cropGarlic"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGarlic.pamgarlicStorage, garlicItem, garlicItem, garlicItem, garlicItem, garlicItem, garlicItem, garlicItem, garlicItem, garlicItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGarlic.garlicItem, 9), pamgarlicStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGarlic.garlicseedpacketItem, garlicseedItem, garlicseedItem, garlicseedItem, garlicseedItem, garlicseedItem, garlicseedItem, garlicseedItem, garlicseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGarlic.garlicseedItem, 8), garlicseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCGarlic.garlicseedboxItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem, garlicseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCGarlic.garlicseedpacketItem, 8), garlicseedboxItem));
		

	 
	 }

}