package mods.PamHarvestCraft.crops.eggplant;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCEggplant", name = "Pam's HarvestCraft Eggplant", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCEggplant
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.eggplant.ClientProxyPamHCEggplant", serverSide = "mods.PamHarvestCraft.crops.eggplant.CommonProxyPamHCEggplant")
	public static CommonProxyPamHCEggplant proxy;
	
	public static int eggplantcropID = 3800;
	public static int eggplantstorageID = 3801;
	public static int eggplantID = 15720;
	public static int eggplantseedID = 15721;
	public static int eggplantseedpacketID = 15722;
	public static int eggplantseedboxID = 15723;
	public static int grilledeggplantID = 15724;

	
	public static boolean seeddropfromgrass = true;
	public static int eggplantcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamEggplantBonemealEvent());
		try {
			cfg.load();
			eggplantcropID = cfg.get(cfg.CATEGORY_BLOCK, "eggplantcropID", 3800).getInt();
			eggplantstorageID = cfg.get(cfg.CATEGORY_BLOCK, "eggplantstorageID", 3801).getInt();
			eggplantID = cfg.get(cfg.CATEGORY_ITEM, "eggplantID", 15720).getInt();
			eggplantseedID = cfg.get(cfg.CATEGORY_ITEM, "eggplantseedID", 15721).getInt();
			eggplantseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "eggplantseedpacketID", 15722).getInt();
			eggplantseedboxID = cfg.get(cfg.CATEGORY_ITEM, "eggplantseedboxID", 15723).getInt();
			grilledeggplantID = cfg.get(cfg.CATEGORY_ITEM, "grilledeggplantID", 15724).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			eggplantcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "eggplantcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCEggplant has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pameggplantCrop;
	public static Block pameggplantStorage;
	public static Item eggplantItem;
	public static Item eggplantseedItem;
	public static Item eggplantseedpacketItem;
	public static Item eggplantseedboxItem;
	public static Item grilledeggplantItem;
	
	public static ItemStack eggplantStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pameggplantCrop = new BlockPamEggplantCrop(eggplantcropID, "eggplant", 0);
		pameggplantStorage = new BlockPamStorage(eggplantstorageID, 0).setUnlocalizedName("PamHarvestCraft:eggplantStorage");
		
		eggplantItem = new ItemPamFood(eggplantID, eggplantcropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:eggplantItem");
		eggplantseedItem = new ItemPamSeed(eggplantseedID, PamHCEggplant.pameggplantCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:eggplantseedItem");
		eggplantseedpacketItem = new ItemPam(eggplantseedpacketID).setUnlocalizedName("PamHarvestCraft:eggplantseedpacketItem");
		eggplantseedboxItem = new ItemPam(eggplantseedboxID).setUnlocalizedName("PamHarvestCraft:eggplantseedboxItem");
		grilledeggplantItem = new ItemPamFood(grilledeggplantID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:grilledeggplantItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(eggplantseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pameggplantCrop);
		ModLoader.registerBlock(pameggplantStorage);
		
		eggplantStorage = new ItemStack(pameggplantStorage, 1, 0);

		LanguageRegistry.addName(eggplantItem, "Eggplant");
		LanguageRegistry.addName(eggplantseedItem, "Eggplant Seed");
		LanguageRegistry.addName(eggplantseedpacketItem, "Eggplant Seed Packet");
		LanguageRegistry.addName(eggplantseedboxItem, "Eggplant Seed Box");
		LanguageRegistry.addName(grilledeggplantItem, "Grilled Eggplant");
		
		LanguageRegistry.addName(eggplantStorage, "Eggplant Crate");

	    
		OreDictionary.registerOre("cropEggplant", PamHCEggplant.eggplantItem);
		OreDictionary.registerOre("seedEggplant", PamHCEggplant.eggplantseedItem);
		OreDictionary.registerOre("foodPopeggplant", PamHCEggplant.grilledeggplantItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCEggplant.eggplantseedItem, eggplantItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCEggplant.eggplantItem, 2), "cropEggplant", "cropEggplant"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCEggplant.pameggplantStorage, eggplantItem, eggplantItem, eggplantItem, eggplantItem, eggplantItem, eggplantItem, eggplantItem, eggplantItem, eggplantItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCEggplant.eggplantItem, 9), pameggplantStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCEggplant.eggplantseedpacketItem, eggplantseedItem, eggplantseedItem, eggplantseedItem, eggplantseedItem, eggplantseedItem, eggplantseedItem, eggplantseedItem, eggplantseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCEggplant.eggplantseedItem, 8), eggplantseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCEggplant.eggplantseedboxItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem, eggplantseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCEggplant.eggplantseedpacketItem, 8), eggplantseedboxItem));
		
		GameRegistry.addSmelting(PamHCEggplant.eggplantItem.itemID, new ItemStack(PamHCEggplant.grilledeggplantItem, 1, 0), 0.1F);
	 
	 }

}