package mods.PamHarvestCraft.crops.cucumber;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCucumber", name = "Pam's HarvestCraft Cucumber", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCucumber
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.cucumber.ClientProxyPamHCCucumber", serverSide = "mods.PamHarvestCraft.crops.cucumber.CommonProxyPamHCCucumber")
	public static CommonProxyPamHCCucumber proxy;
	
	public static int cucumbercropID = 4072;
	public static int cucumberstorageID = 4073;
	public static int cucumberID = 15376;
	public static int cucumberseedID = 15377;
	public static int cucumberseedpacketID = 15378;
	public static int cucumberseedboxID = 15379;

	
	public static boolean seeddropfromgrass = true;
	public static int cucumbercropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamCucumberBonemealEvent());
		try {
			cfg.load();
			cucumbercropID = cfg.get(cfg.CATEGORY_BLOCK, "cucumbercropID", 4072).getInt();
			cucumberstorageID = cfg.get(cfg.CATEGORY_BLOCK, "cucumberstorageID", 4073).getInt();
			cucumberID = cfg.get(cfg.CATEGORY_ITEM, "cucumberID", 15376).getInt();
			cucumberseedID = cfg.get(cfg.CATEGORY_ITEM, "cucumberseedID", 15377).getInt();
			cucumberseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "cucumberseedpacketID", 15378).getInt();
			cucumberseedboxID = cfg.get(cfg.CATEGORY_ITEM, "cucumberseedboxID", 15379).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			cucumbercropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "cucumbercropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCucumber has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamcucumberCrop;
	public static Block pamcucumberStorage;
	public static Item cucumberItem;
	public static Item cucumberseedItem;
	public static Item cucumberseedpacketItem;
	public static Item cucumberseedboxItem;
	
	public static ItemStack cucumberStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamcucumberCrop = new BlockPamCucumberCrop(cucumbercropID, "cucumber", 0);
		pamcucumberStorage = new BlockPamStorage(cucumberstorageID, 0).setUnlocalizedName("PamHarvestCraft:cucumberStorage");
		
		cucumberItem = new ItemPamFood(cucumberID, cucumbercropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:cucumberItem");
		cucumberseedItem = new ItemPamSeed(cucumberseedID, PamHCCucumber.pamcucumberCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:cucumberseedItem");
		cucumberseedpacketItem = new ItemPam(cucumberseedpacketID).setUnlocalizedName("PamHarvestCraft:cucumberseedpacketItem");
		cucumberseedboxItem = new ItemPam(cucumberseedboxID).setUnlocalizedName("PamHarvestCraft:cucumberseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(cucumberseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamcucumberCrop);
		ModLoader.registerBlock(pamcucumberStorage);
		
		cucumberStorage = new ItemStack(pamcucumberStorage, 1, 0);

		LanguageRegistry.addName(cucumberItem, "Cucumber");
		LanguageRegistry.addName(cucumberseedItem, "Cucumber Seed");
		LanguageRegistry.addName(cucumberseedpacketItem, "Cucumber Seed Packet");
		LanguageRegistry.addName(cucumberseedboxItem, "Cucumber Seed Box");
		
		LanguageRegistry.addName(cucumberStorage, "Cucumber Crate");

	    
		OreDictionary.registerOre("cropCucumber", PamHCCucumber.cucumberItem);
		OreDictionary.registerOre("seedCucumber", PamHCCucumber.cucumberseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCucumber.cucumberseedItem, cucumberItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCucumber.cucumberItem, 2), "cropCucumber", "cropCucumber"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCucumber.pamcucumberStorage, cucumberItem, cucumberItem, cucumberItem, cucumberItem, cucumberItem, cucumberItem, cucumberItem, cucumberItem, cucumberItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCucumber.cucumberItem, 9), pamcucumberStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCucumber.cucumberseedpacketItem, cucumberseedItem, cucumberseedItem, cucumberseedItem, cucumberseedItem, cucumberseedItem, cucumberseedItem, cucumberseedItem, cucumberseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCucumber.cucumberseedItem, 8), cucumberseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCucumber.cucumberseedboxItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem, cucumberseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCucumber.cucumberseedpacketItem, 8), cucumberseedboxItem));
		

	 
	 }

}