package mods.PamHarvestCraft.crops.corn;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCorn", name = "Pam's HarvestCraft Corn", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCorn
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.corn.ClientProxyPamHCCorn", serverSide = "mods.PamHarvestCraft.crops.corn.CommonProxyPamHCCorn")
	public static CommonProxyPamHCCorn proxy;
	
	public static int corncropID = 4026;
	public static int cornstorageID = 4027;
	public static int cornID = 15276;
	public static int cornseedID = 15277;
	public static int cornseedpacketID = 15278;
	public static int cornseedboxID = 15279;
	public static int popcornID = 15280;

	
	public static boolean seeddropfromgrass = true;
	public static int corncropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamCornBonemealEvent());
		try {
			cfg.load();
			corncropID = cfg.get(cfg.CATEGORY_BLOCK, "corncropID", 4026).getInt();
			cornstorageID = cfg.get(cfg.CATEGORY_BLOCK, "cornstorageID", 4027).getInt();
			cornID = cfg.get(cfg.CATEGORY_ITEM, "cornID", 15276).getInt();
			cornseedID = cfg.get(cfg.CATEGORY_ITEM, "cornseedID", 15277).getInt();
			cornseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "cornseedpacketID", 15278).getInt();
			cornseedboxID = cfg.get(cfg.CATEGORY_ITEM, "cornseedboxID", 15279).getInt();
			popcornID = cfg.get(cfg.CATEGORY_ITEM, "popcornID", 15280).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			corncropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "corncropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCorn has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamcornCrop;
	public static Block pamcornStorage;
	public static Item cornItem;
	public static Item cornseedItem;
	public static Item cornseedpacketItem;
	public static Item cornseedboxItem;
	public static Item popcornItem;
	
	public static ItemStack cornStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamcornCrop = new BlockPamCornCrop(corncropID, "corn", 0);
		pamcornStorage = new BlockPamStorage(cornstorageID, 0).setUnlocalizedName("PamHarvestCraft:cornStorage");
		
		cornItem = new ItemPamSeedFood(cornID, corncropfoodrestore, 1.2F, PamHCCorn.pamcornCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:cornItem");
		cornseedItem = new ItemPamSeed(cornseedID, PamHCCorn.pamcornCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:cornseedItem");
		cornseedpacketItem = new ItemPam(cornseedpacketID).setUnlocalizedName("PamHarvestCraft:cornseedpacketItem");
		cornseedboxItem = new ItemPam(cornseedboxID).setUnlocalizedName("PamHarvestCraft:cornseedboxItem");
		popcornItem = new ItemPamFood(popcornID, 5, 0.6F, false).setUnlocalizedName("PamHarvestCraft:popcornItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(cornseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamcornCrop);
		ModLoader.registerBlock(pamcornStorage);
		
		cornStorage = new ItemStack(pamcornStorage, 1, 0);

		LanguageRegistry.addName(cornItem, "Corn Bean");
		LanguageRegistry.addName(cornseedItem, "Corn Seed");
		LanguageRegistry.addName(cornseedpacketItem, "Corn Seed Packet");
		LanguageRegistry.addName(cornseedboxItem, "Corn Seed Box");
		LanguageRegistry.addName(popcornItem, "Popcorn");
		
		LanguageRegistry.addName(cornStorage, "Corn Crate");

	    
		OreDictionary.registerOre("cropCorn", PamHCCorn.cornItem);
		OreDictionary.registerOre("seedCorn", PamHCCorn.cornseedItem);
		OreDictionary.registerOre("foodPopcorn", PamHCCorn.popcornItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCorn.cornseedItem, cornItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCorn.cornItem, 2), "cropCorn", "cropCorn"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCorn.pamcornStorage, cornItem, cornItem, cornItem, cornItem, cornItem, cornItem, cornItem, cornItem, cornItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCorn.cornItem, 9), pamcornStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCorn.cornseedpacketItem, cornseedItem, cornseedItem, cornseedItem, cornseedItem, cornseedItem, cornseedItem, cornseedItem, cornseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCorn.cornseedItem, 8), cornseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCorn.cornseedboxItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem, cornseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCorn.cornseedpacketItem, 8), cornseedboxItem));
		
		GameRegistry.addSmelting(PamHCCorn.cornItem.itemID, new ItemStack(PamHCCorn.popcornItem, 1, 0), 0.1F);
	 
	 }

}