package mods.PamHarvestCraft.crops.coffee;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCoffee", name = "Pam's HarvestCraft Coffee", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCoffee
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.coffee.ClientProxyPamHCCoffee", serverSide = "mods.PamHarvestCraft.crops.coffee.CommonProxyPamHCCoffee")
	public static CommonProxyPamHCCoffee proxy;
	
	public static int coffeecropID = 3802;
	public static int coffeestorageID = 3803;
	public static int coffeebeanID = 15725;
	public static int coffeeseedID = 15726;
	public static int coffeeseedpacketID = 15727;
	public static int coffeeseedboxID = 15728;
	public static int coffeeID = 15729;

	
	public static boolean seeddropfromgrass = true;
	public static int coffeecropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamCoffeeBonemealEvent());
		try {
			cfg.load();
			coffeecropID = cfg.get(cfg.CATEGORY_BLOCK, "coffeecropID", 3802).getInt();
			coffeestorageID = cfg.get(cfg.CATEGORY_BLOCK, "coffeestorageID", 3803).getInt();
			coffeebeanID = cfg.get(cfg.CATEGORY_ITEM, "coffeebeanID", 15725).getInt();
			coffeeseedID = cfg.get(cfg.CATEGORY_ITEM, "coffeeseedID", 15726).getInt();
			coffeeseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "coffeeseedpacketID", 15727).getInt();
			coffeeseedboxID = cfg.get(cfg.CATEGORY_ITEM, "coffeeseedboxID", 15728).getInt();
			coffeeID = cfg.get(cfg.CATEGORY_ITEM, "coffeeID", 15729).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			coffeecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "coffeecropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCoffee has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamcoffeeCrop;
	public static Block pamcoffeeStorage;
	public static Item coffeebeanItem;
	public static Item coffeeseedItem;
	public static Item coffeeseedpacketItem;
	public static Item coffeeseedboxItem;
	public static Item coffeeItem;
	
	public static ItemStack coffeeStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamcoffeeCrop = new BlockPamCoffeeCrop(coffeecropID, "coffee", 0);
		pamcoffeeStorage = new BlockPamStorage(coffeestorageID, 0).setUnlocalizedName("PamHarvestCraft:coffeeStorage");
		
		coffeebeanItem = new ItemPamSeedFood(coffeebeanID, coffeecropfoodrestore, 1.2F, PamHCCoffee.pamcoffeeCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:coffeebeanItem");
		coffeeseedItem = new ItemPamSeed(coffeeseedID, PamHCCoffee.pamcoffeeCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:coffeeseedItem");
		coffeeseedpacketItem = new ItemPam(coffeeseedpacketID).setUnlocalizedName("PamHarvestCraft:coffeeseedpacketItem");
		coffeeseedboxItem = new ItemPam(coffeeseedboxID).setUnlocalizedName("PamHarvestCraft:coffeeseedboxItem");
		coffeeItem = new ItemPamFood(coffeeID, 4, 1.2F, false).setUnlocalizedName("PamHarvestCraft:coffeeItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(coffeeseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamcoffeeCrop);
		ModLoader.registerBlock(pamcoffeeStorage);
		
		coffeeStorage = new ItemStack(pamcoffeeStorage, 1, 0);

		LanguageRegistry.addName(coffeebeanItem, "Coffee Bean");
		LanguageRegistry.addName(coffeeseedItem, "Coffee Seed");
		LanguageRegistry.addName(coffeeseedpacketItem, "Coffee Seed Packet");
		LanguageRegistry.addName(coffeeseedboxItem, "Coffee Seed Box");
		LanguageRegistry.addName(coffeeItem, "Cup of Coffee");
		
		LanguageRegistry.addName(coffeeStorage, "Coffee Crate");

	    
		OreDictionary.registerOre("cropCoffee", PamHCCoffee.coffeebeanItem);
		OreDictionary.registerOre("seedCoffee", PamHCCoffee.coffeeseedItem);
		OreDictionary.registerOre("foodCoffee", PamHCCoffee.coffeeItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCoffee.coffeeseedItem, coffeeItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCoffee.coffeeItem, 2), "cropCoffee", "cropCoffee"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCoffee.pamcoffeeStorage, coffeeItem, coffeeItem, coffeeItem, coffeeItem, coffeeItem, coffeeItem, coffeeItem, coffeeItem, coffeeItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCoffee.coffeeItem, 9), pamcoffeeStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCoffee.coffeeseedpacketItem, coffeeseedItem, coffeeseedItem, coffeeseedItem, coffeeseedItem, coffeeseedItem, coffeeseedItem, coffeeseedItem, coffeeseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCoffee.coffeeseedItem, 8), coffeeseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCoffee.coffeeseedboxItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem, coffeeseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCoffee.coffeeseedpacketItem, 8), coffeeseedboxItem));
		
		GameRegistry.addSmelting(PamHCCoffee.coffeebeanItem.itemID, new ItemStack(PamHCCoffee.coffeeItem, 1, 0), 0.1F);
	 
	 }

}