package mods.PamHarvestCraft.crops.celery;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCelery", name = "Pam's HarvestCraft Celery", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCelery
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.celery.ClientProxyPamHCCelery", serverSide = "mods.PamHarvestCraft.crops.celery.CommonProxyPamHCCelery")
	public static CommonProxyPamHCCelery proxy;
	
	public static int celerycropID = 3828;
	public static int celerystorageID = 3829;
	public static int celeryID = 15778;
	public static int celeryseedID = 15779;
	public static int celeryseedpacketID = 15780;
	public static int celeryseedboxID = 15781;

	
	public static boolean seeddropfromgrass = true;
	public static int celerycropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamCeleryBonemealEvent());
		try {
			cfg.load();
			celerycropID = cfg.get(cfg.CATEGORY_BLOCK, "celerycropID", 3828).getInt();
			celerystorageID = cfg.get(cfg.CATEGORY_BLOCK, "celerystorageID", 3829).getInt();
			celeryID = cfg.get(cfg.CATEGORY_ITEM, "celeryID", 15778).getInt();
			celeryseedID = cfg.get(cfg.CATEGORY_ITEM, "celeryseedID", 15779).getInt();
			celeryseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "celeryseedpacketID", 15780).getInt();
			celeryseedboxID = cfg.get(cfg.CATEGORY_ITEM, "celeryseedboxID", 15781).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			celerycropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "celerycropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCelery has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamceleryCrop;
	public static Block pamceleryStorage;
	public static Item celeryItem;
	public static Item celeryseedItem;
	public static Item celeryseedpacketItem;
	public static Item celeryseedboxItem;
	
	public static ItemStack celeryStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamceleryCrop = new BlockPamCeleryCrop(celerycropID, "celery", 0);
		pamceleryStorage = new BlockPamStorage(celerystorageID, 0).setUnlocalizedName("PamHarvestCraft:celeryStorage");
		
		celeryItem = new ItemPamFood(celeryID, celerycropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:celeryItem");
		celeryseedItem = new ItemPamSeed(celeryseedID, PamHCCelery.pamceleryCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:celeryseedItem");
		celeryseedpacketItem = new ItemPam(celeryseedpacketID).setUnlocalizedName("PamHarvestCraft:celeryseedpacketItem");
		celeryseedboxItem = new ItemPam(celeryseedboxID).setUnlocalizedName("PamHarvestCraft:celeryseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(celeryseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamceleryCrop);
		ModLoader.registerBlock(pamceleryStorage);
		
		celeryStorage = new ItemStack(pamceleryStorage, 1, 0);

		LanguageRegistry.addName(celeryItem, "Celery");
		LanguageRegistry.addName(celeryseedItem, "Celery Seed");
		LanguageRegistry.addName(celeryseedpacketItem, "Celery Seed Packet");
		LanguageRegistry.addName(celeryseedboxItem, "Celery Seed Box");
		
		LanguageRegistry.addName(celeryStorage, "Celery Crate");

	    
		OreDictionary.registerOre("cropCelery", PamHCCelery.celeryItem);
		OreDictionary.registerOre("seedCelery", PamHCCelery.celeryseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCelery.celeryseedItem, celeryItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCelery.celeryItem, 2), "cropCelery", "cropCelery"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCelery.pamceleryStorage, celeryItem, celeryItem, celeryItem, celeryItem, celeryItem, celeryItem, celeryItem, celeryItem, celeryItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCelery.celeryItem, 9), pamceleryStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCelery.celeryseedpacketItem, celeryseedItem, celeryseedItem, celeryseedItem, celeryseedItem, celeryseedItem, celeryseedItem, celeryseedItem, celeryseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCelery.celeryseedItem, 8), celeryseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCelery.celeryseedboxItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem, celeryseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCelery.celeryseedpacketItem, 8), celeryseedboxItem));
		

	 
	 }

}