package mods.PamHarvestCraft.crops.cantaloupe;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TradeEntry;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCCantaloupe", name = "Pam's HarvestCraft Cantaloupe", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCCantaloupe
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.cantaloupe.ClientProxyPamHCCantaloupe", serverSide = "mods.PamHarvestCraft.crops.cantaloupe.CommonProxyPamHCCantaloupe")
	public static CommonProxyPamHCCantaloupe proxy;
	
	public static int cantaloupecropID = 3810;
	public static int cantaloupestorageID = 3811;
	public static int cantaloupeID = 15742;
	public static int cantaloupeseedID = 15743;
	public static int cantaloupeseedpacketID = 15744;
	public static int cantaloupeseedboxID = 15745;

	
	public static boolean seeddropfromgrass = true;
	public static int cantaloupecropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamCantaloupeBonemealEvent());
		try {
			cfg.load();
			cantaloupecropID = cfg.get(cfg.CATEGORY_BLOCK, "cantaloupecropID", 3810).getInt();
			cantaloupestorageID = cfg.get(cfg.CATEGORY_BLOCK, "cantaloupestorageID", 3811).getInt();
			cantaloupeID = cfg.get(cfg.CATEGORY_ITEM, "cantaloupeID", 15742).getInt();
			cantaloupeseedID = cfg.get(cfg.CATEGORY_ITEM, "cantaloupeseedID", 15743).getInt();
			cantaloupeseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "cantaloupeseedpacketID", 15744).getInt();
			cantaloupeseedboxID = cfg.get(cfg.CATEGORY_ITEM, "cantaloupeseedboxID", 15745).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			cantaloupecropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "cantaloupecropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCCantaloupe has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamcantaloupeCrop;
	public static Block pamcantaloupeStorage;
	public static Item cantaloupeItem;
	public static Item cantaloupeseedItem;
	public static Item cantaloupeseedpacketItem;
	public static Item cantaloupeseedboxItem;
	
	public static ItemStack cantaloupeStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamcantaloupeCrop = new BlockPamCantaloupeCrop(cantaloupecropID, "cantaloupe", 0);
		pamcantaloupeStorage = new BlockPamStorage(cantaloupestorageID, 0).setUnlocalizedName("PamHarvestCraft:cantaloupeStorage");
		
		cantaloupeItem = new ItemPamFood(cantaloupeID, cantaloupecropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:cantaloupeItem");
		cantaloupeseedItem = new ItemPamSeed(cantaloupeseedID, PamHCCantaloupe.pamcantaloupeCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:cantaloupeseedItem");
		cantaloupeseedpacketItem = new ItemPam(cantaloupeseedpacketID).setUnlocalizedName("PamHarvestCraft:cantaloupeseedpacketItem");
		cantaloupeseedboxItem = new ItemPam(cantaloupeseedboxID).setUnlocalizedName("PamHarvestCraft:cantaloupeseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(cantaloupeseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pamcantaloupeCrop);
		ModLoader.registerBlock(pamcantaloupeStorage);
		
		cantaloupeStorage = new ItemStack(pamcantaloupeStorage, 1, 0);

		LanguageRegistry.addName(cantaloupeItem, "Cantaloupe");
		LanguageRegistry.addName(cantaloupeseedItem, "Cantaloupe Seed");
		LanguageRegistry.addName(cantaloupeseedpacketItem, "Cantaloupe Seed Packet");
		LanguageRegistry.addName(cantaloupeseedboxItem, "Cantaloupe Seed Box");
		
		LanguageRegistry.addName(cantaloupeStorage, "Cantaloupe Crate");

	    
		OreDictionary.registerOre("cropCantaloupe", PamHCCantaloupe.cantaloupeItem);
		OreDictionary.registerOre("seedCantaloupe", PamHCCantaloupe.cantaloupeseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCantaloupe.cantaloupeseedItem, cantaloupeItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCantaloupe.cantaloupeItem, 2), "cropCantaloupe", "cropCantaloupe"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCantaloupe.pamcantaloupeStorage, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem, cantaloupeItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCantaloupe.cantaloupeItem, 9), pamcantaloupeStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCantaloupe.cantaloupeseedpacketItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem, cantaloupeseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCantaloupe.cantaloupeseedItem, 8), cantaloupeseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCCantaloupe.cantaloupeseedboxItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem, cantaloupeseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCCantaloupe.cantaloupeseedpacketItem, 8), cantaloupeseedboxItem));
		

	 
	 }

}