package mods.PamHarvestCraft.crops.beet;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamWeeeFlowers.PamFlowerBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCBeet", name = "Pam's HarvestCraft Beet", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCBeet
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.crops.beet.ClientProxyPamHCBeet", serverSide = "mods.PamHarvestCraft.crops.beet.CommonProxyPamHCBeet")
	public static CommonProxyPamHCBeet proxy;
	
	public static int beetcropID = 3816;
	public static int beetstorageID = 3817;
	public static int beetID = 15754;
	public static int beetseedID = 15755;
	public static int beetseedpacketID = 15756;
	public static int beetseedboxID = 15757;

	
	public static boolean seeddropfromgrass = true;
	public static int beetcropfoodrestore = 1;
	public static int seedrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		MinecraftForge.EVENT_BUS.register(new PamBeetBonemealEvent());
		try {
			cfg.load();
			beetcropID = cfg.get(cfg.CATEGORY_BLOCK, "beetcropID", 3816).getInt();
			beetstorageID = cfg.get(cfg.CATEGORY_BLOCK, "beetstorageID", 3817).getInt();
			beetID = cfg.get(cfg.CATEGORY_ITEM, "beetID", 15754).getInt();
			beetseedID = cfg.get(cfg.CATEGORY_ITEM, "beetseedID", 15755).getInt();
			beetseedpacketID = cfg.get(cfg.CATEGORY_ITEM, "beetseedpacketID", 15756).getInt();
			beetseedboxID = cfg.get(cfg.CATEGORY_ITEM, "beetseedboxID", 15757).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL, "seeddropfromgrass", true).getBoolean(true);
			beetcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL, "beetcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL, "seedrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCBeet has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pambeetCrop;
	public static Block pambeetStorage;
	public static Item beetItem;
	public static Item beetseedItem;
	public static Item beetseedpacketItem;
	public static Item beetseedboxItem;
	
	public static ItemStack beetStorage;


	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pambeetCrop = new BlockPamBeetCrop(beetcropID, "beet", 0);
		pambeetStorage = new BlockPamStorage(beetstorageID, 0).setUnlocalizedName("PamHarvestCraft:beetStorage");
		
		beetItem = new ItemPamSeedFood(beetID, beetcropfoodrestore, 1.2F, PamHCBeet.pambeetCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:beetItem");
		beetseedItem = new ItemPamSeed(beetseedID, PamHCBeet.pambeetCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:beetseedItem");
		beetseedpacketItem = new ItemPam(beetseedpacketID).setUnlocalizedName("PamHarvestCraft:beetseedpacketItem");
		beetseedboxItem = new ItemPam(beetseedboxID).setUnlocalizedName("PamHarvestCraft:beetseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(beetseedItem, 1, 0)), seedrarity);
    	}
		
		ModLoader.registerBlock(pambeetCrop);
		ModLoader.registerBlock(pambeetStorage);
		
		beetStorage = new ItemStack(pambeetStorage, 1, 0);

		LanguageRegistry.addName(beetItem, "Beet");
		LanguageRegistry.addName(beetseedItem, "Beet Seed");
		LanguageRegistry.addName(beetseedpacketItem, "Beet Seed Packet");
		LanguageRegistry.addName(beetseedboxItem, "Beet Seed Box");
		
		LanguageRegistry.addName(beetStorage, "Beet Crate");

	    
		OreDictionary.registerOre("cropBeet", PamHCBeet.beetItem);
		OreDictionary.registerOre("seedBeet", PamHCBeet.beetseedItem);

		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCBeet.beetseedItem, beetItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCBeet.beetItem, 2), "cropBeet", "cropBeet"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCBeet.pambeetStorage, beetItem, beetItem, beetItem, beetItem, beetItem, beetItem, beetItem, beetItem, beetItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCBeet.beetItem, 9), pambeetStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCBeet.beetseedpacketItem, beetseedItem, beetseedItem, beetseedItem, beetseedItem, beetseedItem, beetseedItem, beetseedItem, beetseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCBeet.beetseedItem, 8), beetseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCBeet.beetseedboxItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem, beetseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCBeet.beetseedpacketItem, 8), beetseedboxItem));
		

	 
	 }

}