package mods.PamHarvestCraft.bushes.whitemushroom;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.ItemPamSeedFood;
import mods.PamHarvestCraft.bushes.cactusfruit.PamCactusfruitBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCWhitemushroom", name = "Pam's HarvestCraft Whitemushroom", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCWhitemushroom
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.bushes.whitemushroom.ClientProxyPamHCWhitemushroom", serverSide = "mods.PamHarvestCraft.bushes.whitemushroom.CommonProxyPamHCWhitemushroom")
	public static CommonProxyPamHCWhitemushroom proxy;
	
	public static int whitemushroomcropID = 3900;
	public static int whitemushroomstorageID = 3901;
	public static int whitemushroomwildID = 3902;
	public static int whitemushroomID = 15601;
	public static int whitemushroomseedID = 15602;
	public static int whitemushroomseedpacketID = 15603;
	public static int whitemushroomseedboxID = 15604;
	
	public static boolean seeddropfromgrass = false;
	public static int whitemushroomcropfoodrestore = 1;
	public static int seedrarity = 2;
	public static boolean wildbushgeneration = true;
	public static int wildbushrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamWhitemushroomBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			whitemushroomcropID = cfg.get(cfg.CATEGORY_BLOCK, "whitemushroomcropID", 3900).getInt();
			whitemushroomstorageID = cfg.get(cfg.CATEGORY_BLOCK,"whitemushroomstorageID", 3901).getInt();
			whitemushroomwildID = cfg.get(cfg.CATEGORY_BLOCK,"whitemushroomwildID", 3902).getInt();
			whitemushroomID = cfg.get(cfg.CATEGORY_ITEM,"whitemushroomID", 15601).getInt();
			whitemushroomseedID = cfg.get(cfg.CATEGORY_ITEM,"whitemushroomseedID", 15602).getInt();
			whitemushroomseedpacketID = cfg.get(cfg.CATEGORY_ITEM,"whitemushroomseedpacketID", 15603).getInt();
			whitemushroomseedboxID = cfg.get(cfg.CATEGORY_ITEM,"whitemushroomseedboxID", 15604).getInt();
			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL,"seeddropfromgrass", false).getBoolean(false);
			whitemushroomcropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"whitemushroomcropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL,"seedrarity", 2).getInt();
			wildbushgeneration = cfg.get(cfg.CATEGORY_GENERAL,"wildbushgeneration", true).getBoolean(true);
			wildbushrarity = cfg.get(cfg.CATEGORY_GENERAL,"wildbushrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCWhitemushroom has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamwhitemushroomCrop;
	public static Block pamwhitemushroomStorage;
	public static Block pamwhitemushroomWild;
	public static Item whitemushroomItem;
	public static Item whitemushroomseedItem;
	public static Item whitemushroomseedpacketItem;
	public static Item whitemushroomseedboxItem;

	public static ItemStack whitemushroomWild;
    public static ItemStack whitemushroomStorage;
    
	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamwhitemushroomCrop = new BlockPamWhitemushroomCrop(whitemushroomcropID, "whitemushroom", 0);
		pamwhitemushroomStorage = new BlockPamStorage(whitemushroomstorageID, 0).setUnlocalizedName("PamHarvestCraft:whitemushroomStorage");
		pamwhitemushroomWild = new BlockPamWhitemushroomWild(whitemushroomwildID, "whitemushroom").setUnlocalizedName("PamHarvestCraft:whitemushroomcrop_7");
		
		whitemushroomItem = new ItemPamSeedFood(whitemushroomID, whitemushroomcropfoodrestore, 0.6F, PamHCWhitemushroom.pamwhitemushroomCrop.blockID, Block.wood.blockID).setUnlocalizedName("PamHarvestCraft:whitemushroomItem");
		whitemushroomseedItem = new ItemPamSeed(whitemushroomseedID, PamHCWhitemushroom.pamwhitemushroomCrop.blockID, Block.wood.blockID).setUnlocalizedName("PamHarvestCraft:whitemushroomseedItem");
		whitemushroomseedpacketItem = new ItemPam(whitemushroomseedpacketID).setUnlocalizedName("PamHarvestCraft:whitemushroomseedpacketItem");
		whitemushroomseedboxItem = new ItemPam(whitemushroomseedboxID).setUnlocalizedName("PamHarvestCraft:whitemushroomseedboxItem");
		
		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(whitemushroomseedItem.itemID, 1, 0)), seedrarity);
    	}
		
		MinecraftForge.addGrassPlant(pamwhitemushroomWild, 0, 25);
		
		ModLoader.registerBlock(pamwhitemushroomCrop);
		ModLoader.registerBlock(pamwhitemushroomStorage);
		
		//Block Names
		whitemushroomStorage = new ItemStack(pamwhitemushroomStorage, 1, 0);
        
        LanguageRegistry.addName(whitemushroomStorage, "White Mushroom Crate");
        
        LanguageRegistry.addName(whitemushroomItem, "White Mushroom");
		LanguageRegistry.addName(whitemushroomseedItem, "White Mushroom Seed");
		LanguageRegistry.addName(whitemushroomseedpacketItem, "White Mushroom Seed Packet");
		LanguageRegistry.addName(whitemushroomseedboxItem, "White Mushroom Seed Box");

	    
		OreDictionary.registerOre("cropWhitemushroom", PamHCWhitemushroom.whitemushroomItem);
		OreDictionary.registerOre("seedWhitemushroom", PamHCWhitemushroom.whitemushroomseedItem);

	
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCWhitemushroom.whitemushroomseedItem, whitemushroomItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCWhitemushroom.whitemushroomItem, 2), "cropWhitemushroom", "cropWhitemushroom"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCWhitemushroom.pamwhitemushroomStorage, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem, whitemushroomItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCWhitemushroom.whitemushroomItem, 9), pamwhitemushroomStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCWhitemushroom.whitemushroomseedpacketItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem, whitemushroomseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCWhitemushroom.whitemushroomseedItem, 8), whitemushroomseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCWhitemushroom.whitemushroomseedboxItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem, whitemushroomseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCWhitemushroom.whitemushroomseedpacketItem, 8), whitemushroomseedboxItem));

		if (wildbushgeneration)
		{
		GameRegistry.registerWorldGenerator(new PamWhitemushroomGenerator());
		}
		
	 }

}