package mods.PamHarvestCraft.bushes.sunflower;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenPamSunflower extends WorldGenerator
{
    public WorldGenPamSunflower(int i, int j)
    {
        bushType = j;
        bushBlockID = i;
    }

    public boolean generate(World world, Random random, int i, int j, int k)
    {
        for (int l = 0; l < 8; l++)
        {
            int i1 = (i + random.nextInt(8)) - random.nextInt(8);
            int j1 = (j + random.nextInt(4)) - random.nextInt(4);
            int k1 = (k + random.nextInt(8)) - random.nextInt(8);

            if (world.isAirBlock(i1, j1, k1) && ((BlockPamSunflowerWild)Block.blocksList[bushBlockID]).canBlockStay(world, i1, j1, k1))
            {
                world.setBlock(i1, j1, k1, PamHCSunflower.pamsunflowerWild.blockID, bushType, 2);
            }
        }

        return true;
    }

    private int bushType;
    private int bushBlockID;
	
}